/**
 * Copyright (C) 2001-2003 France Telecom R&D
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.objectweb.util.monolog.api;

/**
 * This class represents a logging level. A logging level allows to
 * classify events by their importance. This interface provides
 * methods to compare Level instances. A level has a name.
 * 
 * @author S.Chassande-Barrioz
 */
public interface Level {

	/**
	 * This method returns true is the current level and the Level parameter are
	 * ordered.
	 */
	boolean isComparableWith(Level o);

	/**
	 * Compares this object with the specified object for order. Returns a 
	 * negative integer, zero, or a positive integer as this object is less than,
	 * equal to, or greater than the specified object.
	 */
	int compareTo(Level o)	;

	/**
	 * Returns the integer value which represents the level.
	 */
	int getIntValue();

	/**
	 * It retrieves the name of the Level
	 */
	String getName();

	/**
	 * It assigns the name of the Level
	 */
	void setName(String n);

}
