/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.lib.util.RunnableStreamListener;

public class Cmd {
    private static final String COMPILER_CLASS_NAME = "com.sun.tools.javac.Main";
    private static final String RMICOMPILER_CLASS_NAME = "sun.rmi.rmic.Main";
    private Vector mCmd = new Vector();
    private String[] mEnv = null;
    private boolean tryToInvoke = false;
    private static final Logger logger = Log.getLogger("org.ow2.jonas.cmd");

    public Cmd(String cmd, boolean invoke) {
        this.mCmd.addElement(cmd);
        this.tryToInvoke = invoke;
    }

    public Cmd(String cmd) {
        this(cmd, false);
    }

    public Cmd(String cmd, String[] env, boolean invoke) {
        this(cmd, invoke);
        this.mEnv = env;
    }

    public void addArgument(String arg) {
        this.mCmd.addElement(arg);
    }

    public void addArguments(List args) {
        Iterator it = args.iterator();
        while (it.hasNext()) {
            this.mCmd.addElement(it.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean run() {
        File toolsJar;
        if (this.tryToInvoke && (toolsJar = new File(System.getProperty("java.home") + File.separator + "lib" + File.separator + "tools.jar")).exists()) {
            ClassLoader classLoader = this.getClass().getClassLoader();
            try {
                classLoader = new URLClassLoader(new URL[]{toolsJar.toURL()}, classLoader);
            }
            catch (MalformedURLException e) {
                logger.log(BasicLevel.WARN, (Object)("The tools.jar file was not found in " + toolsJar.getParent() + "."));
            }
            if (((String)this.mCmd.get(0)).endsWith("javac")) {
                return this.compile(classLoader);
            }
            if (((String)this.mCmd.get(0)).endsWith("rmic")) {
                return this.rmicompile(classLoader);
            }
        }
        Process proc = null;
        boolean val = true;
        try {
            Object[] cmd = new String[this.mCmd.size()];
            this.mCmd.copyInto(cmd);
            proc = Runtime.getRuntime().exec((String[])cmd, this.mEnv);
        }
        catch (IOException e) {
            logger.log(BasicLevel.ERROR, (Object)"exception", (Throwable)e);
            return false;
        }
        RunnableStreamListener out = new RunnableStreamListener(new BufferedReader(new InputStreamReader(proc.getInputStream())), System.out);
        new Thread((Runnable)out, "stdout listener for " + this.toString()).start();
        RunnableStreamListener err = new RunnableStreamListener(new BufferedReader(new InputStreamReader(proc.getErrorStream())), System.err);
        new Thread((Runnable)err, "stderr listener for " + this.toString()).start();
        try {
            val = proc.waitFor() == 0;
        }
        catch (InterruptedException e) {
            logger.log(BasicLevel.ERROR, (Object)"exception", (Throwable)e);
            val = false;
        }
        finally {
            if (proc != null) {
                proc.destroy();
            }
        }
        return val;
    }

    private boolean compile(ClassLoader classLoader) {
        String[] args = new String[this.mCmd.size() - 1];
        for (int i = 0; i < this.mCmd.size() - 1; ++i) {
            args[i] = (String)this.mCmd.get(i + 1);
        }
        try {
            Class<?> c = Class.forName(COMPILER_CLASS_NAME, false, classLoader);
            Object compiler = c.newInstance();
            Method compile = c.getMethod("compile", new String[0].getClass());
            int result = (Integer)compile.invoke(compiler, new Object[]{args});
            return result == 0;
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)"exception", (Throwable)e);
            return false;
        }
    }

    private boolean rmicompile(ClassLoader classLoader) {
        String[] args = new String[this.mCmd.size() - 1];
        for (int i = 0; i < this.mCmd.size() - 1; ++i) {
            args[i] = (String)this.mCmd.get(i + 1);
        }
        try {
            Class<?> c = Class.forName(RMICOMPILER_CLASS_NAME, false, classLoader);
            Constructor<?> cons = c.getConstructor(OutputStream.class, String.class);
            Object rmic = cons.newInstance(System.out, "rmic");
            Method doRmic = c.getMethod("compile", String[].class);
            Boolean result = (Boolean)doRmic.invoke(rmic, new Object[]{args});
            return result;
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)"exception", (Throwable)e);
            return false;
        }
    }

    public Iterator getCommandLine() {
        return this.mCmd.iterator();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Enumeration e = this.mCmd.elements();
        while (e.hasMoreElements()) {
            String arg = (String)e.nextElement();
            if (arg == null) {
                arg = "null";
            }
            for (int i = 0; i < arg.length(); ++i) {
                if (!Character.isWhitespace(arg.charAt(i))) continue;
                arg = "\"" + arg + "\"";
                break;
            }
            buf.append(arg);
            buf.append(' ');
        }
        return buf.toString().trim();
    }
}

