/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.management.javaee;

import javax.management.MBeanException;
import javax.management.Notification;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.ModelMBean;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class ManagedObject {
    private ModelMBean modelMBean = null;
    protected static Log logger = LogFactory.getLog(ManagedObject.class);

    public void setModelMBean(ModelMBean modelMBean) {
        this.modelMBean = modelMBean;
    }

    public ModelMBean getModelMBean() {
        return this.modelMBean;
    }

    public void sendSaveNotification(long sequenceNumber, String resourceName) {
        Notification saveNotif = new Notification("jonas.management.reconfiguration.save", (Object)this.modelMBean, sequenceNumber, resourceName);
        this.sendNotification(saveNotif);
    }

    public void sendReconfigNotification(long sequenceNumber, String resourceName, Object userData) {
        Notification configNotif = new Notification("jonas.management.reconfiguration", (Object)this.modelMBean, sequenceNumber, resourceName);
        configNotif.setUserData(userData);
        this.sendNotification(configNotif);
    }

    protected void sendNotification(Notification notif) {
        try {
            if (this.modelMBean != null) {
                this.modelMBean.sendNotification(notif);
            } else {
                logger.info((Object)("Can't send notification " + notif.toString()), new Object[0]);
            }
        }
        catch (RuntimeOperationsException e) {
            e.printStackTrace();
        }
        catch (MBeanException e) {
            e.printStackTrace();
        }
    }
}

