/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.cpmanager;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.ow2.jonas.lib.cpmanager.JarListException;
import org.ow2.util.url.URLUtils;

public class JarList
extends Vector {
    public JarList() {
    }

    public JarList(StringTokenizer st) {
        while (st.hasMoreTokens()) {
            String fileName = st.nextToken();
            this.add(fileName);
        }
    }

    public JarList(String[] strs) {
        for (int i = 0; i < strs.length; ++i) {
            this.add(strs[i]);
        }
    }

    public void add(String fileName) {
        if (!this.contains(fileName) && !fileName.equals("")) {
            super.add(fileName);
        }
    }

    public URL[] getURLs(String dirName) throws JarListException {
        ArrayList<URL> verifiedUrls = new ArrayList<URL>();
        for (int i = 0; i < this.elementCount; ++i) {
            String s = (String)this.elementData[i];
            try {
                URL potentialUrl = new URL(dirName + File.separator + s);
                File potentialFile = URLUtils.urlToFile((URL)potentialUrl);
                if (!potentialFile.exists()) continue;
                URL verifiedUrl = URLUtils.fileToURL((File)potentialFile.getCanonicalFile());
                verifiedUrls.add(verifiedUrl);
                continue;
            }
            catch (IOException e) {
                throw new JarListException("Error when trying to get the canonical form for the file " + this.elementData[i]);
            }
        }
        return verifiedUrls.toArray(new URL[verifiedUrls.size()]);
    }

    public void merge(JarList jarList) {
        Enumeration e = jarList.elements();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            this.add(s);
        }
    }

    public void remove(JarList jarList) {
        Enumeration e = jarList.elements();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            if (!this.contains(s)) continue;
            this.remove(s);
        }
    }

    public void setRelativePath(String path) {
        if (path.equals("")) {
            return;
        }
        for (int i = 0; i < this.elementCount; ++i) {
            this.elementData[i] = path + File.separator + this.elementData[i];
        }
    }
}

