/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.swissbox.framework;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.rmi.AccessException;
import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.logging.Logger;
import org.ops4j.pax.swissbox.framework.RemoteFramework;
import org.ops4j.pax.swissbox.framework.ServiceLookup;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.launch.FrameworkFactory;
import org.osgi.service.startlevel.StartLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteFrameworkImpl
implements RemoteFramework {
    private static Logger LOG = Logger.getLogger(RemoteFrameworkImpl.class.getName());
    private Framework framework;
    private Registry registry;
    private String name;

    public RemoteFrameworkImpl(Map<String, String> frameworkProperties) throws RemoteException, AlreadyBoundException, BundleException {
        FrameworkFactory frameworkFactory = this.findFrameworkFactory();
        this.framework = frameworkFactory.newFramework(frameworkProperties);
        this.export();
    }

    private void export() throws RemoteException, AccessException {
        String port = System.getProperty("pax.swissbox.framework.rmi.port", "1099");
        this.name = System.getProperty("pax.swissbox.framework.rmi.name");
        this.registry = LocateRegistry.getRegistry(Integer.parseInt(port));
        URL location = this.getClass().getProtectionDomain().getCodeSource().getLocation();
        URL location2 = Bundle.class.getProtectionDomain().getCodeSource().getLocation();
        System.setProperty("java.rmi.server.codebase", location.toString() + " " + location2);
        Remote remote = UnicastRemoteObject.exportObject((Remote)this, 0);
        this.registry.rebind(this.name, remote);
    }

    @Override
    public void init() throws RemoteException, BundleException {
        this.framework.init();
    }

    @Override
    public void start() throws RemoteException, BundleException {
        this.framework.start();
    }

    @Override
    public void stop() throws RemoteException, BundleException {
        this.framework.stop();
        try {
            this.registry.unbind(this.name);
        }
        catch (NotBoundException exc) {
            throw new IllegalStateException(exc);
        }
        UnicastRemoteObject.unexportObject(this, true);
    }

    @Override
    public long installBundle(String bundleUrl) throws RemoteException, BundleException {
        Bundle bundle = this.framework.getBundleContext().installBundle(bundleUrl);
        return bundle.getBundleId();
    }

    @Override
    public long installBundle(String bundleLocation, byte[] bundleData) throws RemoteException, BundleException {
        Bundle bundle = this.framework.getBundleContext().installBundle(bundleLocation, (InputStream)new ByteArrayInputStream(bundleData));
        return bundle.getBundleId();
    }

    @Override
    public void startBundle(long bundleId) throws RemoteException, BundleException {
        this.framework.getBundleContext().getBundle(bundleId).start();
    }

    @Override
    public void stopBundle(long bundleId) throws RemoteException, BundleException {
        this.framework.getBundleContext().getBundle(bundleId).stop();
    }

    @Override
    public void setBundleStartLevel(long bundleId, int startLevel) throws RemoteException, BundleException {
        BundleContext bc = this.framework.getBundleContext();
        StartLevel sl = ServiceLookup.getService(bc, StartLevel.class);
        Bundle bundle = bc.getBundle(bundleId);
        sl.setBundleStartLevel(bundle, startLevel);
    }

    @Override
    public void uninstallBundle(long id) throws RemoteException, BundleException {
        this.framework.getBundleContext().getBundle(id).uninstall();
    }

    public FrameworkFactory findFrameworkFactory() {
        ServiceLoader<FrameworkFactory> loader = ServiceLoader.load(FrameworkFactory.class);
        FrameworkFactory factory = loader.iterator().next();
        return factory;
    }

    private static Map<String, String> buildFrameworkProperties(String[] args) {
        HashMap<String, String> props = new HashMap<String, String>();
        for (String arg : args) {
            if (arg.startsWith("-F")) {
                String key;
                int eq = arg.indexOf("=");
                if (eq == -1) {
                    key = arg.substring(2);
                    props.put(key, null);
                    continue;
                }
                key = arg.substring(2, eq);
                String value = arg.substring(eq + 1);
                props.put(key, value);
                continue;
            }
            LOG.warning("ignoring unknown argument " + arg);
        }
        return props;
    }

    @Override
    public void callService(String filter, String methodName) throws RemoteException, BundleException {
        try {
            LOG.fine("acquiring service " + filter);
            BundleContext bc = this.framework.getBundleContext();
            Object service = ServiceLookup.getServiceByFilter(bc, filter);
            Class<?> klass = service.getClass();
            try {
                Method method = klass.getMethod(methodName, Object[].class);
                LOG.fine("calling service method " + method);
                method.invoke(service, new Object[]{new Object[0]});
            }
            catch (NoSuchMethodException e) {
                Method method = klass.getMethod(methodName, new Class[0]);
                LOG.fine("calling service method  " + method);
                method.invoke(service, new Object[0]);
            }
        }
        catch (SecurityException exc) {
            throw new IllegalStateException(exc);
        }
        catch (NoSuchMethodException exc) {
            throw new IllegalStateException(exc);
        }
        catch (IllegalArgumentException exc) {
            throw new IllegalStateException(exc);
        }
        catch (IllegalAccessException exc) {
            throw new IllegalStateException(exc);
        }
        catch (InvocationTargetException exc) {
            throw new IllegalStateException(exc);
        }
    }

    @Override
    public void setFrameworkStartLevel(int startLevel) {
        BundleContext bc = this.framework.getBundleContext();
        StartLevel sl = ServiceLookup.getService(bc, StartLevel.class);
        sl.setStartLevel(startLevel);
    }

    @Override
    public void waitForState(long bundleId, int state, long timeoutInMillis) throws RemoteException, BundleException {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public static void main(String[] args) throws RemoteException, AlreadyBoundException, BundleException, InterruptedException {
        LOG.fine("starting RemoteFrameworkImpl");
        Map<String, String> props = RemoteFrameworkImpl.buildFrameworkProperties(args);
        RemoteFrameworkImpl impl = new RemoteFrameworkImpl(props);
        impl.start();
    }
}

