/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.rbc.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.util.Dictionary;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.exam.RelativeTimeout;
import org.ops4j.pax.exam.TimeoutException;
import org.ops4j.pax.exam.rbc.internal.NoSuchServiceException;
import org.ops4j.pax.exam.rbc.internal.RemoteBundleContext;
import org.ops4j.pax.swissbox.tracker.ServiceLookup;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.service.startlevel.StartLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteBundleContextImpl
implements RemoteBundleContext,
Serializable {
    private static final long serialVersionUID = 2520051681589147139L;
    private static final Logger LOG = LoggerFactory.getLogger(RemoteBundleContextImpl.class);
    private final transient BundleContext bundleContext;

    public RemoteBundleContextImpl(BundleContext bundleContext) {
        NullArgumentException.validateNotNull((Object)bundleContext, (String)"Bundle context");
        this.bundleContext = bundleContext;
    }

    @Override
    public Object remoteCall(Class<?> serviceType, String methodName, Class<?>[] methodParams, String filter, RelativeTimeout timeout, Object ... actualParams) throws NoSuchServiceException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        LOG.trace("Remote call of [" + serviceType.getName() + "." + methodName + "]");
        Object service = ServiceLookup.getService((BundleContext)this.bundleContext, serviceType, (long)timeout.getValue(), (String)filter);
        return serviceType.getMethod(methodName, methodParams).invoke(service, actualParams);
    }

    @Override
    public long installBundle(String bundleUrl) throws BundleException {
        LOG.trace("Install bundle from URL [" + bundleUrl + "]");
        return this.bundleContext.installBundle(bundleUrl).getBundleId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long installBundle(String bundleLocation, byte[] bundle) throws BundleException {
        LOG.trace("Install bundle [ location=" + bundleLocation + "] from byte array");
        ByteArrayInputStream inp = new ByteArrayInputStream(bundle);
        try {
            long l = this.bundleContext.installBundle(bundleLocation, (InputStream)inp).getBundleId();
            return l;
        }
        finally {
            try {
                inp.close();
            }
            catch (IOException e) {}
        }
    }

    @Override
    public void uninstallBundle(long id) throws BundleException {
        LOG.trace("Uninstall bundle [" + id + "] ");
        try {
            this.bundleContext.getBundle(id).uninstall();
        }
        catch (BundleException e) {
            LOG.error("Problem uninstalling " + id, (Throwable)e);
        }
    }

    @Override
    public void startBundle(long bundleId) throws BundleException {
        this.startBundle(this.bundleContext.getBundle(bundleId));
    }

    @Override
    public void stopBundle(long bundleId) throws BundleException {
        this.bundleContext.getBundle(bundleId).stop();
    }

    @Override
    public void setBundleStartLevel(long bundleId, int startLevel) throws RemoteException, BundleException {
        StartLevel startLevelService = (StartLevel)ServiceLookup.getService((BundleContext)this.bundleContext, StartLevel.class);
        startLevelService.setBundleStartLevel(this.bundleContext.getBundle(bundleId), startLevel);
    }

    @Override
    public void waitForState(long bundleId, int state, RelativeTimeout timeout) {
        Bundle bundle = this.bundleContext.getBundle(bundleId);
        if (bundle == null || timeout.isNoWait() && (bundle == null || bundle.getState() < state)) {
            throw new TimeoutException("There is no waiting timeout set and bundle has state '" + RemoteBundleContextImpl.bundleStateToString(bundle) + "' not '" + RemoteBundleContextImpl.bundleStateToString(state) + "' as expected");
        }
        long startedTrying = System.currentTimeMillis();
        do {
            bundle = this.bundleContext.getBundle(bundleId);
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        } while ((bundle == null || bundle.getState() < state) && (timeout.isNoTimeout() || System.currentTimeMillis() < startedTrying + timeout.getValue()));
        if (bundle == null || bundle.getState() < state) {
            throw new TimeoutException("Timeout passed and bundle has state '" + RemoteBundleContextImpl.bundleStateToString(bundle.getState()) + "' not '" + RemoteBundleContextImpl.bundleStateToString(state) + "' as expected");
        }
    }

    private void startBundle(Bundle bundle) throws BundleException {
        int bundleState = bundle.getState();
        if (bundleState == 32) {
            return;
        }
        Dictionary bundleHeaders = bundle.getHeaders();
        if (bundleHeaders.get("Fragment-Host") != null) {
            return;
        }
        bundle.start();
        this.waitForState(bundle.getBundleId(), 32, RelativeTimeout.TIMEOUT_DEFAULT);
        bundleState = bundle.getState();
        if (bundleState != 32) {
            long bundleId = bundle.getBundleId();
            String bundleName = bundle.getSymbolicName();
            String bundleStateStr = RemoteBundleContextImpl.bundleStateToString(bundleState);
            throw new BundleException("Bundle (" + bundleId + ", " + bundleName + ") not started (still " + bundleStateStr + ")");
        }
    }

    private static String bundleStateToString(Bundle bundle) {
        if (bundle == null) {
            return "not installed";
        }
        return RemoteBundleContextImpl.bundleStateToString(bundle.getState());
    }

    private static String bundleStateToString(int bundleState) {
        switch (bundleState) {
            case 32: {
                return "active";
            }
            case 2: {
                return "installed";
            }
            case 4: {
                return "resolved";
            }
            case 8: {
                return "starting";
            }
            case 16: {
                return "stopping";
            }
            case 1: {
                return "uninstalled";
            }
        }
        return "unknown (" + bundleState + ")";
    }
}

