/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.karaf.container.internal;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import org.ops4j.net.FreePort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RMIRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(RMIRegistry.class);
    private static final int UNSELECTED = -1;
    private static final int TREASURE = 30;
    private final Integer defaultPort;
    private final String host;
    private Integer port = -1;
    private Integer altMin;
    private Integer altTo;

    public RMIRegistry(Integer defaultPort, Integer alternativeRangeFrom, Integer alternativeRangeTo) {
        try {
            this.host = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException("Cannot select localhost. That usually not a good sign for networking..");
        }
        this.defaultPort = defaultPort;
        this.altMin = alternativeRangeFrom;
        this.altTo = alternativeRangeTo;
    }

    public synchronized RMIRegistry selectGracefully() {
        int alternativePort = new FreePort(this.altMin.intValue(), this.altTo.intValue()).getPort();
        this.port = this.select(alternativePort);
        if (this.port == -1) {
            throw new IllegalStateException("No port found for RMI at all. Even though " + alternativePort + " should have worked. Thats.. not. good. at. all.");
        }
        this.printTakenStatus();
        return this;
    }

    private void printTakenStatus() {
        int inUse = this.port - this.altMin + 1;
        int max = this.altTo - this.altMin;
        String info = "Currently " + inUse + " out of " + max + " ports are in use. Port range is from " + this.altMin + " up to " + this.altTo;
        if (inUse + 30 > max) {
            LOG.warn("--------------");
            LOG.warn("BEWARE !!! " + info);
            LOG.warn("--------------");
        } else {
            LOG.debug(info);
        }
    }

    private Integer select(int portNumber) {
        if (this.reuseRegistry(portNumber)) {
            LOG.debug("Reuse Registry on " + portNumber);
            return portNumber;
        }
        if (this.createNewRegistry(portNumber)) {
            LOG.debug("Created Registry on " + portNumber);
            return portNumber;
        }
        return -1;
    }

    private boolean createNewRegistry(int portNumber) {
        try {
            Registry registry = LocateRegistry.createRegistry(portNumber);
            return this.verifyRegistry(registry);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean reuseRegistry(int portNumber) {
        Registry reg = null;
        try {
            reg = LocateRegistry.getRegistry(portNumber);
            return this.verifyRegistry(reg);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean verifyRegistry(Registry reg) {
        if (reg != null) {
            try {
                String[] objectsRemote;
                for (String r : objectsRemote = reg.list()) {
                    LOG.info("-- Remotely available already: " + r);
                }
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }
}

