/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;

public class ResourceFileManager {
    private static final Logger LOG = Logger.getLogger(ResourceFileManager.class.getName());

    public void copyResourceToFile(Class<?> callingClass, String sourceResource, File destinationFile) {
        InputStream is = null;
        OutputStream os = null;
        try {
            int bytesRead;
            byte[] buffer = new byte[4096];
            is = callingClass.getResourceAsStream(sourceResource);
            os = new FileOutputStream(destinationFile);
            if (is == null) {
                throw new FileNotFoundException("Could not find " + sourceResource);
            }
            while ((bytesRead = is.read(buffer)) >= 0) {
                os.write(buffer, 0, bytesRead);
            }
            is.close();
            os.close();
        }
        catch (IOException e) {
            throw new OsmosisRuntimeException("Unable to copy resource " + sourceResource + " to file " + destinationFile);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception e) {
                    LOG.warning("Unable to close input stream for resource " + sourceResource);
                }
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (Exception e) {
                    LOG.warning("Unable to close output stream for file " + destinationFile);
                }
            }
        }
    }
}

