/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.store;

import java.io.IOException;
import java.io.OutputStream;

public class OffsetTrackingOutputStream
extends OutputStream {
    private OutputStream out;
    private long byteCount;

    public OffsetTrackingOutputStream(OutputStream out) {
        this.out = out;
        this.byteCount = 0L;
    }

    public long getByteCount() {
        return this.byteCount;
    }

    @Override
    public void write(int b) throws IOException {
        ++this.byteCount;
        this.out.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.byteCount += (long)len;
        this.out.write(b, off, len);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.byteCount += (long)b.length;
        this.out.write(b);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

