/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.store;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.openstreetmap.osmosis.core.lifecycle.Releasable;
import org.openstreetmap.osmosis.core.store.IndexElement;
import org.openstreetmap.osmosis.core.store.IndexRangeIterator;
import org.openstreetmap.osmosis.core.store.NoSuchIndexElementException;
import org.openstreetmap.osmosis.core.store.RandomAccessObjectStoreReader;

public class IndexStoreReader<K, T extends IndexElement<K>>
implements Releasable {
    private RandomAccessObjectStoreReader<T> indexStoreReader;
    private Comparator<K> ordering;
    private boolean elementDetailsInitialized;
    private long elementCount;
    private long elementSize;
    private long binarySearchElementCount;
    private int binarySearchDepth;
    private List<ComparisonElement<K>> binarySearchCache;

    public IndexStoreReader(RandomAccessObjectStoreReader<T> indexStoreReader, Comparator<K> ordering) {
        this.indexStoreReader = indexStoreReader;
        this.ordering = ordering;
        this.elementDetailsInitialized = false;
    }

    private void initializeElementDetails() {
        long dataLength = this.indexStoreReader.length();
        if (dataLength <= 0L) {
            this.elementCount = 0L;
            this.elementSize = 0L;
        } else {
            this.indexStoreReader.get(0L);
            this.elementSize = this.indexStoreReader.position();
            this.elementCount = dataLength / this.elementSize;
        }
        this.binarySearchDepth = 0;
        this.binarySearchElementCount = 1L;
        while (this.binarySearchElementCount < this.elementCount + 1L) {
            ++this.binarySearchDepth;
            this.binarySearchElementCount *= 2L;
        }
        this.binarySearchCache = new ArrayList<ComparisonElement<K>>(this.binarySearchDepth);
        for (int i = 0; i < this.binarySearchDepth; ++i) {
            this.binarySearchCache.add(null);
        }
        this.elementDetailsInitialized = true;
    }

    private long getKeyIndex(K searchKey) {
        if (!this.elementDetailsInitialized) {
            this.initializeElementDetails();
        }
        long intervalBegin = -1L;
        long intervalEnd = this.binarySearchElementCount;
        int currentSearchDepth = 0;
        boolean useCache = true;
        boolean higherThanPrevious = true;
        while (intervalBegin + 1L < intervalEnd) {
            long intervalMid = (intervalBegin + intervalEnd) / 2L;
            if (intervalMid < this.elementCount) {
                boolean comparisonHigher;
                Object intervalMidKey = null;
                if (useCache) {
                    ComparisonElement<K> searchElement = this.binarySearchCache.get(currentSearchDepth);
                    if (searchElement != null && searchElement.getIndexOffset() == intervalMid) {
                        intervalMidKey = searchElement.getKey();
                    } else {
                        useCache = false;
                    }
                }
                if (!useCache) {
                    intervalMidKey = ((IndexElement)this.indexStoreReader.get(intervalMid * this.elementSize)).getKey();
                }
                boolean bl = comparisonHigher = this.ordering.compare(searchKey, intervalMidKey) > 0;
                if (!useCache) {
                    this.binarySearchCache.set(currentSearchDepth, new ComparisonElement<Object>(intervalMid, intervalMidKey));
                }
                higherThanPrevious = comparisonHigher;
            } else {
                higherThanPrevious = false;
            }
            ++currentSearchDepth;
            if (higherThanPrevious) {
                intervalBegin = intervalMid;
                continue;
            }
            intervalEnd = intervalMid;
        }
        return intervalEnd;
    }

    public T get(K key) {
        IndexElement element;
        Object locatedKey;
        long keyIndex = this.getKeyIndex(key);
        if (keyIndex < this.elementCount && this.ordering.compare(key, locatedKey = (element = (IndexElement)this.indexStoreReader.get(keyIndex * this.elementSize)).getKey()) == 0) {
            return (T)element;
        }
        throw new NoSuchIndexElementException("Requested key " + key + " does not exist.");
    }

    public Iterator<T> getRange(K beginKey, K endKey) {
        long keyIndex = this.getKeyIndex(beginKey);
        return new IndexRangeIterator<K, T>(this.indexStoreReader.iterate(keyIndex * this.elementSize), beginKey, endKey, this.ordering);
    }

    @Override
    public void release() {
        this.indexStoreReader.release();
    }

    private static class ComparisonElement<K> {
        private long indexOffset;
        private K key;

        public ComparisonElement(long indexOffset, K key) {
            this.indexOffset = indexOffset;
            this.key = key;
        }

        public long getIndexOffset() {
            return this.indexOffset;
        }

        public K getKey() {
            return this.key;
        }
    }
}

