/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.store;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.task.v0_6.Initializable;

public class DataPostbox<T>
implements Initializable {
    private int bufferCapacity;
    private int chunkSize;
    private Lock lock;
    private Condition dataWaitCondition;
    private Map<String, Object> processingMetaData;
    private Collection<T> centralQueue;
    private Collection<T> inboundQueue;
    private Queue<T> outboundQueue;
    private boolean inputInitialized;
    private boolean outputInitialized;
    private boolean inputComplete;
    private boolean outputComplete;
    private boolean inputReleased;
    private boolean outputReleased;
    private boolean inputExit;
    private boolean outputExit;
    private boolean inputOkay;
    private boolean outputOkay;

    public DataPostbox(int capacity) {
        if (capacity <= 0) {
            throw new OsmosisRuntimeException("A capacity of " + capacity + " is invalid, must be greater than 0.");
        }
        this.bufferCapacity = capacity;
        this.chunkSize = this.bufferCapacity / 4;
        if (this.chunkSize <= 0) {
            this.chunkSize = 1;
        }
        this.lock = new ReentrantLock();
        this.dataWaitCondition = this.lock.newCondition();
        this.inputInitialized = false;
        this.outputInitialized = false;
        this.inputComplete = false;
        this.outputComplete = false;
        this.inputReleased = false;
        this.outputReleased = false;
        this.inputExit = true;
        this.outputExit = true;
        this.inputOkay = true;
        this.outputOkay = true;
        this.initializeQueues();
    }

    private void initializeQueues() {
        this.centralQueue = new ArrayList<T>();
        this.inboundQueue = new ArrayList<T>();
        this.outboundQueue = new ArrayDeque<T>();
    }

    private void checkForOutputErrors() {
        if (!this.outputOkay) {
            throw new OsmosisRuntimeException("An output error has occurred, aborting.");
        }
    }

    private void checkForInputErrors() {
        if (!this.inputOkay) {
            throw new OsmosisRuntimeException("An input error has occurred, aborting.");
        }
    }

    private void waitForUpdate() {
        try {
            this.dataWaitCondition.await();
        }
        catch (InterruptedException e) {
            throw new OsmosisRuntimeException("Thread was interrupted.", e);
        }
    }

    private void signalUpdate() {
        this.dataWaitCondition.signal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateCentralQueue() {
        this.lock.lock();
        try {
            this.checkForOutputErrors();
            while (this.centralQueue.size() >= this.bufferCapacity) {
                this.waitForUpdate();
                this.checkForOutputErrors();
            }
            this.centralQueue.addAll(this.inboundQueue);
            this.inboundQueue.clear();
            this.signalUpdate();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void consumeCentralQueue() {
        this.lock.lock();
        try {
            this.checkForInputErrors();
            while (this.centralQueue.size() <= 0 && !this.inputComplete) {
                this.waitForUpdate();
                this.checkForInputErrors();
            }
            this.outboundQueue.addAll(this.centralQueue);
            this.centralQueue.clear();
            this.signalUpdate();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize(Map<String, Object> metaData) {
        if (this.inputInitialized) {
            throw new OsmosisRuntimeException("initialize has already been called");
        }
        this.lock.lock();
        try {
            this.checkForOutputErrors();
            this.processingMetaData = metaData;
            this.inputInitialized = true;
            this.signalUpdate();
            while (!this.outputInitialized) {
                this.waitForUpdate();
                this.checkForOutputErrors();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void put(T o) {
        if (!this.inputInitialized) {
            throw new OsmosisRuntimeException("initialize has not been called");
        }
        this.inboundQueue.add(o);
        if (this.inboundQueue.size() >= this.chunkSize) {
            this.populateCentralQueue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void complete() {
        if (!this.inputInitialized) {
            throw new OsmosisRuntimeException("initialize has not been called");
        }
        this.lock.lock();
        try {
            this.populateCentralQueue();
            this.inputComplete = true;
            this.signalUpdate();
            while (!this.outputComplete) {
                this.waitForUpdate();
                this.checkForOutputErrors();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        this.lock.lock();
        try {
            if (!this.inputComplete) {
                this.inputOkay = false;
            }
            this.inputReleased = true;
            this.inputExit = false;
            this.signalUpdate();
            while (!this.outputReleased) {
                this.waitForUpdate();
            }
            this.initializeQueues();
            this.inputInitialized = false;
            this.inputComplete = false;
            this.inputReleased = false;
            this.inputExit = true;
            this.inputOkay = true;
            this.signalUpdate();
            while (!this.outputExit) {
                this.waitForUpdate();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> outputInitialize() {
        if (this.outputInitialized) {
            throw new OsmosisRuntimeException("outputInitialize has already been called");
        }
        this.lock.lock();
        try {
            this.checkForInputErrors();
            while (!this.inputInitialized) {
                this.waitForUpdate();
                this.checkForInputErrors();
            }
            this.outputInitialized = true;
            this.signalUpdate();
            Map<String, Object> map = this.processingMetaData;
            return map;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean hasNext() {
        if (!this.outputInitialized) {
            throw new OsmosisRuntimeException("outputInitialize has not been called");
        }
        int queueSize = this.outboundQueue.size();
        if (queueSize <= 0) {
            this.consumeCentralQueue();
            queueSize = this.outboundQueue.size();
        }
        return queueSize > 0;
    }

    public T getNext() {
        if (this.hasNext()) {
            T result = this.outboundQueue.remove();
            return result;
        }
        throw new OsmosisRuntimeException("No data is available, should call hasNext first.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void outputComplete() {
        if (!this.outputInitialized) {
            throw new OsmosisRuntimeException("outputInitialize has not been called");
        }
        this.lock.lock();
        try {
            this.checkForInputErrors();
            while (!this.inputComplete) {
                this.waitForUpdate();
                this.checkForInputErrors();
            }
            this.outputComplete = true;
            this.signalUpdate();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void outputRelease() {
        this.lock.lock();
        try {
            if (!this.outputComplete) {
                this.outputOkay = false;
                this.signalUpdate();
            }
            while (!this.inputReleased) {
                this.waitForUpdate();
            }
            this.outputInitialized = false;
            this.outputComplete = false;
            this.outputReleased = true;
            this.outputExit = false;
            this.outputOkay = true;
            this.signalUpdate();
            while (!this.inputExit) {
                this.waitForUpdate();
            }
            this.outputReleased = false;
            this.outputExit = true;
            this.signalUpdate();
        }
        finally {
            this.lock.unlock();
        }
    }
}

