/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.database;

import org.openstreetmap.osmosis.core.store.GenericObjectReader;
import org.openstreetmap.osmosis.core.store.GenericObjectWriter;
import org.openstreetmap.osmosis.core.store.StoreClassRegister;
import org.openstreetmap.osmosis.core.store.StoreReader;
import org.openstreetmap.osmosis.core.store.StoreWriter;
import org.openstreetmap.osmosis.core.store.Storeable;

public class DbFeatureHistory<T extends Storeable>
implements Storeable {
    private T feature;
    private int version;

    public DbFeatureHistory(T feature, int version) {
        this.feature = feature;
        this.version = version;
    }

    public DbFeatureHistory(StoreReader sr, StoreClassRegister scr) {
        this.feature = new GenericObjectReader(sr, scr).readObject();
        this.version = sr.readInteger();
    }

    @Override
    public void store(StoreWriter sw, StoreClassRegister scr) {
        new GenericObjectWriter(sw, scr).writeObject((Storeable)this.feature);
        sw.writeInteger(this.version);
    }

    public T getFeature() {
        return this.feature;
    }

    public int getVersion() {
        return this.version;
    }
}

