/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.rdbms.mysql;

import java.sql.Connection;
import java.sql.SQLException;
import org.openrdf.query.algebra.Regex;
import org.openrdf.query.algebra.ValueConstant;
import org.openrdf.query.algebra.ValueExpr;
import org.openrdf.sail.rdbms.RdbmsConnectionFactory;
import org.openrdf.sail.rdbms.algebra.base.SqlExprSupport;
import org.openrdf.sail.rdbms.algebra.factories.BooleanExprFactory;
import org.openrdf.sail.rdbms.evaluation.QueryBuilderFactory;
import org.openrdf.sail.rdbms.evaluation.SqlCastBuilder;
import org.openrdf.sail.rdbms.evaluation.SqlExprBuilder;
import org.openrdf.sail.rdbms.evaluation.SqlRegexBuilder;
import org.openrdf.sail.rdbms.exceptions.UnsupportedRdbmsOperatorException;
import org.openrdf.sail.rdbms.mysql.MySqlTable;
import org.openrdf.sail.rdbms.mysql.MySqlValueTable;
import org.openrdf.sail.rdbms.optimizers.SelectQueryOptimizerFactory;
import org.openrdf.sail.rdbms.schema.NamespacesTable;
import org.openrdf.sail.rdbms.schema.RdbmsTable;
import org.openrdf.sail.rdbms.schema.TableFactory;
import org.openrdf.sail.rdbms.schema.ValueTable;
import org.openrdf.sail.rdbms.schema.ValueTableFactory;

public class MySqlConnectionFactory
extends RdbmsConnectionFactory {
    private static final String FEILD_COLLATE = " CHARACTER SET utf8 COLLATE utf8_bin";

    @Override
    protected String getFromDummyTable() {
        return "FROM DUAL";
    }

    @Override
    protected TableFactory createTableFactory() {
        return new TableFactory(){

            @Override
            protected RdbmsTable newTable(String name) {
                return new MySqlTable(name);
            }
        };
    }

    @Override
    protected ValueTableFactory createValueTableFactory() {
        return new ValueTableFactory(this.createTableFactory()){

            @Override
            protected ValueTable newValueTable() {
                return new MySqlValueTable();
            }

            @Override
            public NamespacesTable createNamespacesTable(Connection conn) {
                return new NamespacesTable(this.createTable(conn, "NAMESPACE_PREFIXES")){

                    @Override
                    protected void createTable() throws SQLException {
                        StringBuilder sb = new StringBuilder();
                        sb.append("  prefix VARCHAR(127)");
                        sb.append(MySqlConnectionFactory.FEILD_COLLATE);
                        sb.append(",\n  namespace TEXT ");
                        sb.append(MySqlConnectionFactory.FEILD_COLLATE);
                        sb.append(" NOT NULL\n");
                        this.createTable(sb);
                    }
                };
            }
        };
    }

    @Override
    protected SelectQueryOptimizerFactory createSelectQueryOptimizerFactory() {
        return new SelectQueryOptimizerFactory(){

            @Override
            protected BooleanExprFactory createBooleanExprFactory() {
                return new BooleanExprFactory(){

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Override
                    public void meet(Regex node) throws UnsupportedRdbmsOperatorException {
                        ValueExpr flagsArg = node.getFlagsArg();
                        if (flagsArg == null) {
                            super.meet(node);
                            return;
                        } else {
                            if (!(flagsArg instanceof ValueConstant)) throw SqlExprSupport.unsupported(node);
                            ValueConstant flags = (ValueConstant)flagsArg;
                            if (!flags.getValue().stringValue().equals("i")) throw SqlExprSupport.unsupported(node);
                            super.meet(node);
                        }
                    }
                };
            }
        };
    }

    @Override
    protected QueryBuilderFactory createQueryBuilderFactory() {
        return new QueryBuilderFactory(){

            @Override
            public SqlRegexBuilder createSqlRegexBuilder(SqlExprBuilder where) {
                return new SqlRegexBuilder(where, this){

                    @Override
                    protected void appendRegExp(SqlExprBuilder where) {
                        this.appendValue(where);
                        if (!this.flags().getParameters().isEmpty()) {
                            where.append(" COLLATE utf8_general_ci");
                        }
                        where.append(" REGEXP ");
                        this.appendPattern(where);
                    }
                };
            }

            @Override
            public SqlCastBuilder createSqlCastBuilder(SqlExprBuilder where, int type) {
                return new SqlCastBuilder(where, this, type){

                    @Override
                    protected CharSequence getSqlType(int type) {
                        switch (type) {
                            case 12: {
                                return "CHAR";
                            }
                        }
                        return super.getSqlType(type);
                    }
                };
            }
        };
    }
}

