/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.rdbms.iteration.base;

import info.aduna.iteration.CloseableIterationBase;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RdbmIterationBase<T, X extends Exception>
extends CloseableIterationBase<T, X> {
    private PreparedStatement stmt;
    private ResultSet rs;
    private boolean advanced;
    private boolean hasNext;

    public RdbmIterationBase(PreparedStatement stmt) throws SQLException {
        this.stmt = stmt;
        if (stmt != null) {
            this.rs = stmt.executeQuery();
        }
    }

    protected void handleClose() throws X {
        super.handleClose();
        try {
            this.rs.close();
            this.stmt.close();
        }
        catch (SQLException e) {
            throw this.convertSQLException(e);
        }
    }

    public boolean hasNext() throws X {
        if (this.advanced) {
            return this.hasNext;
        }
        this.advanced = true;
        try {
            this.hasNext = this.rs.next();
            return this.hasNext;
        }
        catch (SQLException e) {
            throw this.convertSQLException(e);
        }
    }

    public T next() throws X {
        try {
            if (!this.advanced) {
                this.hasNext = this.rs.next();
            }
            this.advanced = false;
            return this.convert(this.rs);
        }
        catch (SQLException e) {
            throw this.convertSQLException(e);
        }
    }

    public void remove() throws X {
        try {
            this.rs.rowDeleted();
        }
        catch (SQLException e) {
            throw this.convertSQLException(e);
        }
    }

    protected abstract T convert(ResultSet var1) throws SQLException;

    protected abstract X convertSQLException(SQLException var1);
}

