/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.rdbms.algebra;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.openrdf.query.algebra.QueryModelNode;
import org.openrdf.query.algebra.QueryModelVisitor;
import org.openrdf.sail.rdbms.algebra.ColumnVar;
import org.openrdf.sail.rdbms.algebra.base.FromItem;
import org.openrdf.sail.rdbms.algebra.base.RdbmsQueryModelVisitorBase;
import org.openrdf.sail.rdbms.schema.ValueTypes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnionItem
extends FromItem {
    private List<FromItem> union = new ArrayList<FromItem>();

    public UnionItem(String alias) {
        super(alias);
    }

    @Override
    public FromItem getFromItem(String alias) {
        for (FromItem from : this.union) {
            FromItem item = from.getFromItem(alias);
            if (item == null) continue;
            return item;
        }
        return super.getFromItem(alias);
    }

    public List<String> getSelectVarNames() {
        ArrayList<ColumnVar> vars = new ArrayList<ColumnVar>();
        for (FromItem from : this.union) {
            from.appendVars(vars);
        }
        ArrayList<String> selectVars = new ArrayList<String>();
        for (ColumnVar var : vars) {
            if (var.isHidden() || selectVars.contains(var.getName())) continue;
            selectVars.add(var.getName());
        }
        return selectVars;
    }

    public List<ColumnVar> getSelectColumns() {
        ArrayList<ColumnVar> vars = new ArrayList<ColumnVar>();
        for (FromItem from : this.union) {
            from.appendVars(vars);
        }
        ArrayList<ColumnVar> columns = new ArrayList<ColumnVar>();
        HashMap<String, ColumnVar> selectVars = new HashMap<String, ColumnVar>();
        for (ColumnVar var : vars) {
            if (var.isHidden()) continue;
            if (selectVars.containsKey(var.getName())) {
                ColumnVar existing = (ColumnVar)selectVars.get(var.getName());
                existing.setValue(null);
                ValueTypes types = existing.getTypes();
                types = types.clone().merge(var.getTypes());
                existing.setTypes(types);
                continue;
            }
            String name = var.getAlias() + var.getColumn();
            ColumnVar as = var.as(this.getAlias(), name);
            columns.add(as);
            selectVars.put(var.getName(), as);
        }
        return columns;
    }

    @Override
    public List<ColumnVar> appendVars(List<ColumnVar> columns) {
        columns.addAll(this.getSelectColumns());
        return super.appendVars(columns);
    }

    @Override
    public ColumnVar getVar(String name) {
        for (ColumnVar var : this.appendVars(new ArrayList<ColumnVar>())) {
            if (!var.getName().equals(name)) continue;
            return var;
        }
        return null;
    }

    @Override
    public ColumnVar getVarForChildren(String name) {
        for (FromItem join : this.union) {
            ColumnVar var = join.getVar(name);
            if (var == null) continue;
            return var;
        }
        return super.getVarForChildren(name);
    }

    public void addUnion(FromItem from) {
        this.union.add(from);
        from.setParentNode((QueryModelNode)this);
    }

    public List<FromItem> getUnion() {
        return this.union;
    }

    @Override
    public UnionItem clone() {
        UnionItem clone = (UnionItem)super.clone();
        clone.union = new ArrayList<FromItem>();
        for (FromItem from : this.union) {
            clone.addUnion(from.clone());
        }
        return clone;
    }

    @Override
    public <X extends Exception> void visit(RdbmsQueryModelVisitorBase<X> visitor) throws X {
        visitor.meet(this);
    }

    @Override
    public void replaceChildNode(QueryModelNode current, QueryModelNode replacement) {
        int n = this.union.size();
        for (int i = 0; i < n; ++i) {
            if (current != this.union.get(i)) continue;
            this.union.set(i, (FromItem)replacement);
            return;
        }
        super.replaceChildNode(current, replacement);
    }

    @Override
    public <X extends Exception> void visitChildren(QueryModelVisitor<X> visitor) throws X {
        super.visitChildren(visitor);
        for (FromItem join : new ArrayList<FromItem>(this.union)) {
            join.visit(visitor);
        }
    }
}

