/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.nativerdf;

import java.io.IOException;
import org.openrdf.query.Dataset;
import org.openrdf.query.algebra.evaluation.EvaluationStrategy;
import org.openrdf.query.algebra.evaluation.TripleSource;
import org.openrdf.query.algebra.evaluation.limited.LimitedSizeEvaluationStrategy;
import org.openrdf.sail.nativerdf.NativeStore;
import org.openrdf.sail.nativerdf.NativeStoreConnection;
import org.openrdf.sail.nativerdf.NativeTripleSource;

public class LimitedSizeNativeStoreConnection
extends NativeStoreConnection {
    private int maxCollectionsSize = Integer.MAX_VALUE;

    protected LimitedSizeNativeStoreConnection(NativeStore nativeStore) throws IOException {
        super(nativeStore);
    }

    public int getMaxCollectionsSize() {
        return this.maxCollectionsSize;
    }

    public void setMaxCollectionsSize(int maxCollectionsSize) {
        this.maxCollectionsSize = maxCollectionsSize;
    }

    @Override
    protected EvaluationStrategy getEvaluationStrategy(Dataset dataset, NativeTripleSource tripleSource) {
        return new LimitedSizeEvaluationStrategy((TripleSource)tripleSource, dataset, this.maxCollectionsSize);
    }
}

