/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.nativerdf;

import info.aduna.concurrent.locks.Lock;
import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.CloseableIteratorIteration;
import info.aduna.iteration.ExceptionConvertingIteration;
import info.aduna.iteration.Iteration;
import info.aduna.iteration.Iterations;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.openrdf.OpenRDFUtil;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.QueryModelVisitor;
import org.openrdf.query.algebra.QueryRoot;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.Var;
import org.openrdf.query.algebra.evaluation.EvaluationStrategy;
import org.openrdf.query.algebra.evaluation.TripleSource;
import org.openrdf.query.algebra.evaluation.impl.BindingAssigner;
import org.openrdf.query.algebra.evaluation.impl.CompareOptimizer;
import org.openrdf.query.algebra.evaluation.impl.ConjunctiveConstraintSplitter;
import org.openrdf.query.algebra.evaluation.impl.ConstantOptimizer;
import org.openrdf.query.algebra.evaluation.impl.DisjunctiveConstraintOptimizer;
import org.openrdf.query.algebra.evaluation.impl.EvaluationStatistics;
import org.openrdf.query.algebra.evaluation.impl.EvaluationStrategyImpl;
import org.openrdf.query.algebra.evaluation.impl.FilterOptimizer;
import org.openrdf.query.algebra.evaluation.impl.IterativeEvaluationOptimizer;
import org.openrdf.query.algebra.evaluation.impl.OrderLimitOptimizer;
import org.openrdf.query.algebra.evaluation.impl.QueryJoinOptimizer;
import org.openrdf.query.algebra.evaluation.impl.QueryModelNormalizer;
import org.openrdf.query.algebra.evaluation.impl.SameTermFilterOptimizer;
import org.openrdf.query.algebra.helpers.QueryModelVisitorBase;
import org.openrdf.query.impl.EmptyBindingSet;
import org.openrdf.sail.Sail;
import org.openrdf.sail.SailChangedEvent;
import org.openrdf.sail.SailException;
import org.openrdf.sail.helpers.DefaultSailChangedEvent;
import org.openrdf.sail.helpers.NotifyingSailConnectionBase;
import org.openrdf.sail.helpers.SailBase;
import org.openrdf.sail.inferencer.InferencerConnection;
import org.openrdf.sail.nativerdf.NativeEvaluationStatistics;
import org.openrdf.sail.nativerdf.NativeStatementIterator;
import org.openrdf.sail.nativerdf.NativeStore;
import org.openrdf.sail.nativerdf.NativeTripleSource;
import org.openrdf.sail.nativerdf.TripleStore;
import org.openrdf.sail.nativerdf.ValueStore;
import org.openrdf.sail.nativerdf.btree.RecordIterator;

public class NativeStoreConnection
extends NotifyingSailConnectionBase
implements InferencerConnection {
    protected final NativeStore nativeStore;
    private volatile DefaultSailChangedEvent sailChangedEvent;
    private volatile Lock txnLock;
    private volatile boolean txnLockAcquired;

    protected NativeStoreConnection(NativeStore nativeStore) throws IOException {
        super((SailBase)nativeStore);
        this.nativeStore = nativeStore;
        this.sailChangedEvent = new DefaultSailChangedEvent((Sail)nativeStore);
    }

    protected void closeInternal() {
    }

    protected CloseableIteration<? extends BindingSet, QueryEvaluationException> evaluateInternal(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings, boolean includeInferred) throws SailException {
        this.logger.trace("Incoming query model:\n{}", (Object)tupleExpr);
        tupleExpr = tupleExpr.clone();
        if (!(tupleExpr instanceof QueryRoot)) {
            tupleExpr = new QueryRoot(tupleExpr);
        }
        try {
            this.replaceValues(tupleExpr);
            NativeTripleSource tripleSource = new NativeTripleSource(this.nativeStore, includeInferred, this.transactionActive());
            EvaluationStrategy strategy = this.getEvaluationStrategy(dataset, tripleSource);
            new BindingAssigner().optimize(tupleExpr, dataset, bindings);
            new ConstantOptimizer(strategy).optimize(tupleExpr, dataset, bindings);
            new CompareOptimizer().optimize(tupleExpr, dataset, bindings);
            new ConjunctiveConstraintSplitter().optimize(tupleExpr, dataset, bindings);
            new DisjunctiveConstraintOptimizer().optimize(tupleExpr, dataset, bindings);
            new SameTermFilterOptimizer().optimize(tupleExpr, dataset, bindings);
            new QueryModelNormalizer().optimize(tupleExpr, dataset, bindings);
            new QueryJoinOptimizer((EvaluationStatistics)new NativeEvaluationStatistics(this.nativeStore)).optimize(tupleExpr, dataset, bindings);
            new IterativeEvaluationOptimizer().optimize(tupleExpr, dataset, bindings);
            new FilterOptimizer().optimize(tupleExpr, dataset, bindings);
            new OrderLimitOptimizer().optimize(tupleExpr, dataset, bindings);
            this.logger.trace("Optimized query model:\n{}", (Object)tupleExpr);
            return strategy.evaluate(tupleExpr, EmptyBindingSet.getInstance());
        }
        catch (QueryEvaluationException e) {
            throw new SailException((Throwable)e);
        }
    }

    protected EvaluationStrategy getEvaluationStrategy(Dataset dataset, NativeTripleSource tripleSource) {
        return new EvaluationStrategyImpl((TripleSource)tripleSource, dataset);
    }

    protected void replaceValues(TupleExpr tupleExpr) throws SailException {
        tupleExpr.visit((QueryModelVisitor)new QueryModelVisitorBase<SailException>(){

            public void meet(Var var) {
                if (var.hasValue()) {
                    var.setValue((Value)NativeStoreConnection.this.nativeStore.getValueStore().getNativeValue(var.getValue()));
                }
            }
        });
    }

    protected CloseableIteration<? extends Resource, SailException> getContextIDsInternal() throws SailException {
        try {
            CloseableIteration<Resource, IOException> contextIter = this.nativeStore.getContextIDs(this.transactionActive());
            return new ExceptionConvertingIteration<Resource, SailException>(contextIter){

                protected SailException convert(Exception e) {
                    if (e instanceof IOException) {
                        return new SailException((Throwable)e);
                    }
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    if (e == null) {
                        throw new IllegalArgumentException("e must not be null");
                    }
                    throw new IllegalArgumentException("Unexpected exception type: " + e.getClass());
                }
            };
        }
        catch (IOException e) {
            throw new SailException((Throwable)e);
        }
    }

    protected CloseableIteration<? extends Statement, SailException> getStatementsInternal(Resource subj, URI pred, Value obj, boolean includeInferred, Resource ... contexts) throws SailException {
        Lock tempWriteLock = null;
        try {
            boolean readTransaction;
            boolean bl = readTransaction = this.transactionActive() && this.txnLockAcquired;
            if (!readTransaction && (tempWriteLock = this.nativeStore.tryTransactionLock()) != null) {
                readTransaction = true;
            }
            CloseableIteration<? extends Statement, IOException> iter = this.nativeStore.createStatementIterator(subj, pred, obj, includeInferred, readTransaction, contexts);
            ExceptionConvertingIteration<Statement, SailException> exceptionConvertingIteration = new ExceptionConvertingIteration<Statement, SailException>(iter){

                protected SailException convert(Exception e) {
                    if (e instanceof IOException) {
                        return new SailException((Throwable)e);
                    }
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    if (e == null) {
                        throw new IllegalArgumentException("e must not be null");
                    }
                    throw new IllegalArgumentException("Unexpected exception type: " + e.getClass());
                }
            };
            return exceptionConvertingIteration;
        }
        catch (IOException e) {
            throw new SailException("Unable to get statements", (Throwable)e);
        }
        finally {
            if (tempWriteLock != null) {
                tempWriteLock.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long sizeInternal(Resource ... contexts) throws SailException {
        OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
        try {
            List<Integer> contextIDs = contexts.length == 0 ? Arrays.asList(-1) : this.nativeStore.getContextIDs(contexts);
            long size = 0L;
            for (int contextID : contextIDs) {
                RecordIterator iter = this.nativeStore.getTripleStore().getTriples(-1, -1, -1, contextID, true, this.transactionActive());
                try {
                    while (iter.next() != null) {
                        ++size;
                    }
                }
                finally {
                    iter.close();
                }
            }
            return size;
        }
        catch (IOException e) {
            throw new SailException((Throwable)e);
        }
    }

    protected CloseableIteration<? extends Namespace, SailException> getNamespacesInternal() throws SailException {
        return new CloseableIteratorIteration(this.nativeStore.getNamespaceStore().iterator());
    }

    protected String getNamespaceInternal(String prefix) throws SailException {
        return this.nativeStore.getNamespaceStore().getNamespace(prefix);
    }

    protected void startTransactionInternal() throws SailException {
    }

    private void acquireExclusiveTransactionLock() throws SailException {
        if (!this.txnLockAcquired) {
            this.txnLock = this.nativeStore.getTransactionLock();
            boolean releaseLock = true;
            try {
                this.nativeStore.getTripleStore().startTransaction();
                releaseLock = false;
                this.txnLockAcquired = true;
            }
            catch (IOException e) {
                throw new SailException((Throwable)e);
            }
            finally {
                if (releaseLock) {
                    this.txnLock.release();
                    this.txnLockAcquired = false;
                }
            }
        }
    }

    protected void commitInternal() throws SailException {
        if (this.txnLockAcquired) {
            try {
                this.nativeStore.getValueStore().sync();
                this.nativeStore.getNamespaceStore().sync();
                this.nativeStore.getTripleStore().commit();
                this.txnLock.release();
                this.txnLockAcquired = false;
            }
            catch (IOException e) {
                throw new SailException((Throwable)e);
            }
            catch (RuntimeException e) {
                this.logger.error("Encountered an unexpected problem while trying to commit", (Throwable)e);
                throw e;
            }
            this.nativeStore.notifySailChanged((SailChangedEvent)this.sailChangedEvent);
            this.sailChangedEvent = new DefaultSailChangedEvent((Sail)this.nativeStore);
        }
    }

    protected void rollbackInternal() throws SailException {
        try {
            this.nativeStore.getValueStore().sync();
            this.nativeStore.getTripleStore().rollback();
        }
        catch (IOException e) {
            throw new SailException((Throwable)e);
        }
        catch (RuntimeException e) {
            this.logger.error("Encountered an unexpected problem while trying to roll back", (Throwable)e);
            throw e;
        }
        finally {
            if (this.txnLockAcquired) {
                this.txnLock.release();
            }
            this.txnLockAcquired = false;
        }
    }

    protected void addStatementInternal(Resource subj, URI pred, Value obj, Resource ... contexts) throws SailException {
        this.addStatement(subj, pred, obj, true, contexts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addInferredStatement(Resource subj, URI pred, Value obj, Resource ... contexts) throws SailException {
        this.connectionLock.readLock().lock();
        try {
            this.verifyIsOpen();
            this.updateLock.lock();
            try {
                this.verifyIsActive();
                boolean bl = this.addStatement(subj, pred, obj, false, contexts);
                this.updateLock.unlock();
                return bl;
            }
            catch (Throwable throwable) {
                this.updateLock.unlock();
                throw throwable;
            }
        }
        finally {
            this.connectionLock.readLock().unlock();
        }
    }

    private boolean addStatement(Resource subj, URI pred, Value obj, boolean explicit, Resource ... contexts) throws SailException {
        this.acquireExclusiveTransactionLock();
        OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
        boolean result = false;
        try {
            ValueStore valueStore = this.nativeStore.getValueStore();
            int subjID = valueStore.storeValue((Value)subj);
            int predID = valueStore.storeValue((Value)pred);
            int objID = valueStore.storeValue(obj);
            if (contexts.length == 0) {
                contexts = new Resource[]{null};
            }
            for (Resource context : contexts) {
                int contextID = 0;
                if (context != null) {
                    contextID = valueStore.storeValue((Value)context);
                }
                boolean wasNew = this.nativeStore.getTripleStore().storeTriple(subjID, predID, objID, contextID, explicit);
                result |= wasNew;
                if (!wasNew) continue;
                this.sailChangedEvent.setStatementsAdded(true);
                if (!this.hasConnectionListeners()) continue;
                Statement st = context != null ? valueStore.createStatement(subj, pred, obj, context) : valueStore.createStatement(subj, pred, obj);
                this.notifyStatementAdded(st);
            }
        }
        catch (IOException e) {
            throw new SailException((Throwable)e);
        }
        catch (RuntimeException e) {
            this.logger.error("Encountered an unexpected problem while trying to add a statement", (Throwable)e);
            throw e;
        }
        return result;
    }

    protected void removeStatementsInternal(Resource subj, URI pred, Value obj, Resource ... contexts) throws SailException {
        this.removeStatements(subj, pred, obj, true, contexts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeInferredStatement(Resource subj, URI pred, Value obj, Resource ... contexts) throws SailException {
        this.connectionLock.readLock().lock();
        try {
            this.verifyIsOpen();
            this.updateLock.lock();
            try {
                this.verifyIsActive();
                int removeCount = this.removeStatements(subj, pred, obj, false, contexts);
                boolean bl = removeCount > 0;
                this.updateLock.unlock();
                return bl;
            }
            catch (Throwable throwable) {
                this.updateLock.unlock();
                throw throwable;
            }
        }
        finally {
            this.connectionLock.readLock().unlock();
        }
    }

    private int removeStatements(Resource subj, URI pred, Value obj, boolean explicit, Resource ... contexts) throws SailException {
        this.acquireExclusiveTransactionLock();
        OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
        try {
            TripleStore tripleStore = this.nativeStore.getTripleStore();
            ValueStore valueStore = this.nativeStore.getValueStore();
            int subjID = -1;
            if (subj != null && (subjID = valueStore.getID((Value)subj)) == -1) {
                return 0;
            }
            int predID = -1;
            if (pred != null && (predID = valueStore.getID((Value)pred)) == -1) {
                return 0;
            }
            int objID = -1;
            if (obj != null && (objID = valueStore.getID(obj)) == -1) {
                return 0;
            }
            ArrayList<Integer> contextIDList = new ArrayList<Integer>(contexts.length);
            if (contexts.length == 0) {
                contextIDList.add(-1);
            } else {
                for (Resource context : contexts) {
                    if (context == null) {
                        contextIDList.add(0);
                        continue;
                    }
                    int contextID = valueStore.getID((Value)context);
                    if (contextID == -1) continue;
                    contextIDList.add(contextID);
                }
            }
            int removeCount = 0;
            for (int i = 0; i < contextIDList.size(); ++i) {
                int contextID = (Integer)contextIDList.get(i);
                List removedStatements = Collections.emptyList();
                if (this.hasConnectionListeners()) {
                    RecordIterator btreeIter = tripleStore.getTriples(subjID, predID, objID, contextID, explicit, true);
                    NativeStatementIterator iter = new NativeStatementIterator(btreeIter, valueStore);
                    removedStatements = Iterations.asList((Iteration)iter);
                }
                removeCount += tripleStore.removeTriples(subjID, predID, objID, contextID, explicit);
                for (Statement st : removedStatements) {
                    this.notifyStatementRemoved(st);
                }
            }
            if (removeCount > 0) {
                this.sailChangedEvent.setStatementsRemoved(true);
            }
            return removeCount;
        }
        catch (IOException e) {
            throw new SailException((Throwable)e);
        }
        catch (RuntimeException e) {
            this.logger.error("Encountered an unexpected problem while trying to remove statements", (Throwable)e);
            throw e;
        }
    }

    protected void clearInternal(Resource ... contexts) throws SailException {
        this.removeStatements(null, null, null, true, contexts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearInferred(Resource ... contexts) throws SailException {
        this.connectionLock.readLock().lock();
        try {
            this.verifyIsOpen();
            this.updateLock.lock();
            try {
                this.verifyIsActive();
                this.removeStatements(null, null, null, false, contexts);
            }
            finally {
                this.updateLock.unlock();
            }
        }
        finally {
            this.connectionLock.readLock().unlock();
        }
    }

    public void flushUpdates() {
    }

    protected void setNamespaceInternal(String prefix, String name) throws SailException {
        this.acquireExclusiveTransactionLock();
        this.nativeStore.getNamespaceStore().setNamespace(prefix, name);
    }

    protected void removeNamespaceInternal(String prefix) throws SailException {
        this.acquireExclusiveTransactionLock();
        this.nativeStore.getNamespaceStore().removeNamespace(prefix);
    }

    protected void clearNamespacesInternal() throws SailException {
        this.acquireExclusiveTransactionLock();
        this.nativeStore.getNamespaceStore().clear();
    }
}

