/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.nativerdf;

import info.aduna.io.NioFile;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;

class TxnStatusFile {
    private static final Charset US_ASCII = Charset.forName("US-ASCII");
    public static final String FILE_NAME = "txn-status";
    private final NioFile nioFile;

    public TxnStatusFile(File dataDir) throws IOException {
        File statusFile = new File(dataDir, FILE_NAME);
        this.nioFile = new NioFile(statusFile, "rwd");
        if (this.nioFile.size() == 0L) {
            this.setTxnStatus(TxnStatus.NONE);
        }
    }

    public void close() throws IOException {
        this.nioFile.close();
    }

    public void setTxnStatus(TxnStatus txnStatus) throws IOException {
        byte[] bytes = txnStatus.name().getBytes(US_ASCII);
        this.nioFile.truncate((long)bytes.length);
        this.nioFile.writeBytes(bytes, 0L);
    }

    public TxnStatus getTxnStatus() throws IOException {
        byte[] bytes = this.nioFile.readBytes(0L, (int)this.nioFile.size());
        String s = new String(bytes, US_ASCII);
        try {
            return TxnStatus.valueOf(s);
        }
        catch (IllegalArgumentException e) {
            s = new String(bytes);
            try {
                return TxnStatus.valueOf(s);
            }
            catch (IllegalArgumentException e2) {
                return TxnStatus.UNKNOWN;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TxnStatus {
        NONE,
        ACTIVE,
        COMMITTING,
        ROLLING_BACK,
        UNKNOWN;

    }
}

