/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail;

import info.aduna.iteration.CloseableIteration;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.UpdateExpr;
import org.openrdf.sail.SailException;
import org.openrdf.sail.UnknownSailTransactionStateException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface SailConnection {
    public boolean isOpen() throws SailException;

    public void close() throws SailException;

    public CloseableIteration<? extends BindingSet, QueryEvaluationException> evaluate(TupleExpr var1, Dataset var2, BindingSet var3, boolean var4) throws SailException;

    public void executeUpdate(UpdateExpr var1, Dataset var2, BindingSet var3, boolean var4) throws SailException;

    public CloseableIteration<? extends Resource, SailException> getContextIDs() throws SailException;

    public CloseableIteration<? extends Statement, SailException> getStatements(Resource var1, URI var2, Value var3, boolean var4, Resource ... var5) throws SailException;

    public long size(Resource ... var1) throws SailException;

    public void begin() throws SailException;

    public void commit() throws SailException;

    public void rollback() throws SailException;

    public boolean isActive() throws UnknownSailTransactionStateException;

    public void addStatement(Resource var1, URI var2, Value var3, Resource ... var4) throws SailException;

    public void removeStatements(Resource var1, URI var2, Value var3, Resource ... var4) throws SailException;

    public void clear(Resource ... var1) throws SailException;

    public CloseableIteration<? extends Namespace, SailException> getNamespaces() throws SailException;

    public String getNamespace(String var1) throws SailException;

    public void setNamespace(String var1, String var2) throws SailException;

    public void removeNamespace(String var1) throws SailException;

    public void clearNamespaces() throws SailException;
}

