/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.rio.turtle;

import info.aduna.io.IndentingWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFWriter;
import org.openrdf.rio.helpers.RDFWriterBase;
import org.openrdf.rio.turtle.TurtleUtil;

public class TurtleWriter
extends RDFWriterBase
implements RDFWriter {
    protected IndentingWriter writer;
    protected boolean writingStarted;
    protected boolean statementClosed;
    protected Resource lastWrittenSubject;
    protected URI lastWrittenPredicate;

    public TurtleWriter(OutputStream out) {
        this(new OutputStreamWriter(out, Charset.forName("UTF-8")));
    }

    public TurtleWriter(Writer writer) {
        this.writer = new IndentingWriter(writer);
        this.namespaceTable = new LinkedHashMap();
        this.writingStarted = false;
        this.statementClosed = true;
        this.lastWrittenSubject = null;
        this.lastWrittenPredicate = null;
    }

    public RDFFormat getRDFFormat() {
        return RDFFormat.TURTLE;
    }

    public void startRDF() throws RDFHandlerException {
        if (this.writingStarted) {
            throw new RuntimeException("Document writing has already started");
        }
        this.writingStarted = true;
        try {
            for (Map.Entry entry : this.namespaceTable.entrySet()) {
                String name = (String)entry.getKey();
                String prefix = (String)entry.getValue();
                this.writeNamespace(prefix, name);
            }
            if (!this.namespaceTable.isEmpty()) {
                this.writer.writeEOL();
            }
        }
        catch (IOException e) {
            throw new RDFHandlerException((Throwable)e);
        }
    }

    public void endRDF() throws RDFHandlerException {
        if (!this.writingStarted) {
            throw new RuntimeException("Document writing has not yet started");
        }
        try {
            this.closePreviousStatement();
            this.writer.flush();
        }
        catch (IOException e) {
            throw new RDFHandlerException((Throwable)e);
        }
        finally {
            this.writingStarted = false;
        }
    }

    public void handleNamespace(String prefix, String name) throws RDFHandlerException {
        try {
            if (!this.namespaceTable.containsKey(name)) {
                boolean isLegalPrefix;
                boolean bl = isLegalPrefix = prefix.length() == 0 || TurtleUtil.isLegalPrefix(prefix);
                if (!isLegalPrefix || this.namespaceTable.containsValue(prefix)) {
                    if (prefix.length() == 0 || !isLegalPrefix) {
                        prefix = "ns";
                    }
                    int number = 1;
                    while (this.namespaceTable.containsValue(prefix + number)) {
                        ++number;
                    }
                    prefix = prefix + number;
                }
                this.namespaceTable.put(name, prefix);
                if (this.writingStarted) {
                    this.closePreviousStatement();
                    this.writeNamespace(prefix, name);
                }
            }
        }
        catch (IOException e) {
            throw new RDFHandlerException((Throwable)e);
        }
    }

    public void handleStatement(Statement st) throws RDFHandlerException {
        if (!this.writingStarted) {
            throw new RuntimeException("Document writing has not yet been started");
        }
        Resource subj = st.getSubject();
        URI pred = st.getPredicate();
        Value obj = st.getObject();
        try {
            if (subj.equals(this.lastWrittenSubject)) {
                if (pred.equals((Object)this.lastWrittenPredicate)) {
                    this.writer.write(" , ");
                } else {
                    this.writer.write(" ;");
                    this.writer.writeEOL();
                    this.writePredicate(pred);
                    this.writer.write(" ");
                    this.lastWrittenPredicate = pred;
                }
            } else {
                this.closePreviousStatement();
                this.writer.writeEOL();
                this.writeResource(subj);
                this.writer.write(" ");
                this.lastWrittenSubject = subj;
                this.writePredicate(pred);
                this.writer.write(" ");
                this.lastWrittenPredicate = pred;
                this.statementClosed = false;
                this.writer.increaseIndentation();
            }
            this.writeValue(obj);
        }
        catch (IOException e) {
            throw new RDFHandlerException((Throwable)e);
        }
    }

    public void handleComment(String comment) throws RDFHandlerException {
        try {
            this.closePreviousStatement();
            if (comment.indexOf(13) != -1 || comment.indexOf(10) != -1) {
                StringTokenizer st = new StringTokenizer(comment, "\r\n");
                while (st.hasMoreTokens()) {
                    this.writeCommentLine(st.nextToken());
                }
            } else {
                this.writeCommentLine(comment);
            }
        }
        catch (IOException e) {
            throw new RDFHandlerException((Throwable)e);
        }
    }

    protected void writeCommentLine(String line) throws IOException {
        this.writer.write("# ");
        this.writer.write(line);
        this.writer.writeEOL();
    }

    protected void writeNamespace(String prefix, String name) throws IOException {
        this.writer.write("@prefix ");
        this.writer.write(prefix);
        this.writer.write(": <");
        this.writer.write(TurtleUtil.encodeURIString(name));
        this.writer.write("> .");
        this.writer.writeEOL();
    }

    protected void writePredicate(URI predicate) throws IOException {
        if (predicate.equals((Object)RDF.TYPE)) {
            this.writer.write("a");
        } else {
            this.writeURI(predicate);
        }
    }

    protected void writeValue(Value val) throws IOException {
        if (val instanceof Resource) {
            this.writeResource((Resource)val);
        } else {
            this.writeLiteral((Literal)val);
        }
    }

    protected void writeResource(Resource res) throws IOException {
        if (res instanceof URI) {
            this.writeURI((URI)res);
        } else {
            this.writeBNode((BNode)res);
        }
    }

    protected void writeURI(URI uri) throws IOException {
        String uriString = uri.toString();
        String prefix = null;
        int splitIdx = TurtleUtil.findURISplitIndex(uriString);
        if (splitIdx > 0) {
            String namespace = uriString.substring(0, splitIdx);
            prefix = (String)this.namespaceTable.get(namespace);
        }
        if (prefix != null) {
            this.writer.write(prefix);
            this.writer.write(":");
            this.writer.write(uriString.substring(splitIdx));
        } else {
            this.writer.write("<");
            this.writer.write(TurtleUtil.encodeURIString(uriString));
            this.writer.write(">");
        }
    }

    protected void writeBNode(BNode bNode) throws IOException {
        this.writer.write("_:");
        this.writer.write(bNode.getID());
    }

    protected void writeLiteral(Literal lit) throws IOException {
        String label = lit.getLabel();
        if (label.indexOf(10) > 0 || label.indexOf(13) > 0 || label.indexOf(9) > 0) {
            this.writer.write("\"\"\"");
            this.writer.write(TurtleUtil.encodeLongString(label));
            this.writer.write("\"\"\"");
        } else {
            this.writer.write("\"");
            this.writer.write(TurtleUtil.encodeString(label));
            this.writer.write("\"");
        }
        if (lit.getLanguage() != null) {
            this.writer.write("@");
            this.writer.write(lit.getLanguage());
        } else if (lit.getDatatype() != null) {
            this.writer.write("^^");
            this.writeURI(lit.getDatatype());
        }
    }

    protected void closePreviousStatement() throws IOException {
        if (!this.statementClosed) {
            this.writer.write(" .");
            this.writer.writeEOL();
            this.writer.decreaseIndentation();
            this.statementClosed = true;
            this.lastWrittenSubject = null;
            this.lastWrittenPredicate = null;
        }
    }
}

