/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.rio.rdfxml;

import info.aduna.xml.XMLUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Map;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFWriter;

public class RDFXMLWriter
implements RDFWriter {
    protected Writer writer;
    protected String defaultNamespace;
    protected final Map<String, String> namespaceTable;
    protected boolean writingStarted;
    protected boolean headerWritten;
    protected Resource lastWrittenSubject;

    public RDFXMLWriter(OutputStream out) {
        this(new OutputStreamWriter(out, Charset.forName("UTF-8")));
    }

    public RDFXMLWriter(Writer writer) {
        this.writer = writer;
        this.namespaceTable = new LinkedHashMap<String, String>();
        this.writingStarted = false;
        this.headerWritten = false;
        this.lastWrittenSubject = null;
    }

    public RDFFormat getRDFFormat() {
        return RDFFormat.RDFXML;
    }

    public void startRDF() {
        if (this.writingStarted) {
            throw new IllegalStateException("Document writing has already started");
        }
        this.writingStarted = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeHeader() throws IOException {
        try {
            this.setNamespace("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
            this.writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            this.writeStartOfStartTag("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "RDF");
            if (this.defaultNamespace != null) {
                this.writeNewLine();
                this.writeIndent();
                this.writer.write("xmlns=\"");
                this.writer.write(XMLUtil.escapeDoubleQuotedAttValue((String)this.defaultNamespace));
                this.writer.write("\"");
            }
            for (Map.Entry<String, String> entry : this.namespaceTable.entrySet()) {
                String name = entry.getKey();
                String prefix = entry.getValue();
                this.writeNewLine();
                this.writeIndent();
                this.writer.write("xmlns:");
                this.writer.write(prefix);
                this.writer.write("=\"");
                this.writer.write(XMLUtil.escapeDoubleQuotedAttValue((String)name));
                this.writer.write("\"");
            }
            this.writeEndOfStartTag();
            this.writeNewLine();
        }
        finally {
            this.headerWritten = true;
        }
    }

    public void endRDF() throws RDFHandlerException {
        if (!this.writingStarted) {
            throw new IllegalStateException("Document writing has not yet started");
        }
        try {
            if (!this.headerWritten) {
                this.writeHeader();
            }
            this.flushPendingStatements();
            this.writeNewLine();
            this.writeEndTag("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "RDF");
            this.writer.flush();
        }
        catch (IOException e) {
            throw new RDFHandlerException((Throwable)e);
        }
        finally {
            this.writingStarted = false;
            this.headerWritten = false;
        }
    }

    public void handleNamespace(String prefix, String name) {
        this.setNamespace(prefix, name);
    }

    protected void setNamespace(String prefix, String name) {
        if (this.headerWritten) {
            return;
        }
        if (prefix.length() == 0) {
            this.defaultNamespace = name;
            return;
        }
        if (this.namespaceTable.containsKey(name)) {
            return;
        }
        boolean isLegalPrefix = XMLUtil.isNCName((String)prefix);
        if (!isLegalPrefix || this.namespaceTable.containsValue(prefix)) {
            if (!isLegalPrefix) {
                prefix = "ns";
            }
            int number = 1;
            while (this.namespaceTable.containsValue(prefix + number)) {
                ++number;
            }
            prefix = prefix + number;
        }
        this.namespaceTable.put(name, prefix);
    }

    public void handleStatement(Statement st) throws RDFHandlerException {
        if (!this.writingStarted) {
            throw new IllegalStateException("Document writing has not yet been started");
        }
        Resource subj = st.getSubject();
        URI pred = st.getPredicate();
        Value obj = st.getObject();
        String predString = pred.toString();
        int predSplitIdx = XMLUtil.findURISplitIndex((String)predString);
        if (predSplitIdx == -1) {
            throw new RDFHandlerException("Unable to create XML namespace-qualified name for predicate: " + predString);
        }
        String predNamespace = predString.substring(0, predSplitIdx);
        String predLocalName = predString.substring(predSplitIdx);
        try {
            if (!this.headerWritten) {
                this.writeHeader();
            }
            if (!subj.equals(this.lastWrittenSubject)) {
                this.flushPendingStatements();
                this.writeNewLine();
                this.writeStartOfStartTag("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "Description");
                if (subj instanceof BNode) {
                    BNode bNode = (BNode)subj;
                    this.writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "nodeID", bNode.getID());
                } else {
                    URI uri = (URI)subj;
                    this.writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "about", uri.toString());
                }
                this.writeEndOfStartTag();
                this.writeNewLine();
                this.lastWrittenSubject = subj;
            }
            this.writeIndent();
            this.writeStartOfStartTag(predNamespace, predLocalName);
            if (obj instanceof Resource) {
                Resource objRes = (Resource)obj;
                if (objRes instanceof BNode) {
                    BNode bNode = (BNode)objRes;
                    this.writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "nodeID", bNode.getID());
                } else {
                    URI uri = (URI)objRes;
                    this.writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "resource", uri.toString());
                }
                this.writeEndOfEmptyTag();
            } else if (obj instanceof Literal) {
                Literal objLit = (Literal)obj;
                if (objLit.getLanguage() != null) {
                    this.writeAttribute("xml:lang", objLit.getLanguage());
                }
                boolean isXMLLiteral = false;
                URI datatype = objLit.getDatatype();
                if (datatype != null) {
                    isXMLLiteral = datatype.equals(RDF.XMLLITERAL);
                    if (isXMLLiteral) {
                        this.writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "parseType", "Literal");
                    } else {
                        this.writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "datatype", datatype.toString());
                    }
                }
                this.writeEndOfStartTag();
                if (isXMLLiteral) {
                    this.writer.write(objLit.getLabel());
                } else {
                    this.writeCharacterData(objLit.getLabel());
                }
                this.writeEndTag(predNamespace, predLocalName);
            }
            this.writeNewLine();
        }
        catch (IOException e) {
            throw new RDFHandlerException((Throwable)e);
        }
    }

    public void handleComment(String comment) throws RDFHandlerException {
        try {
            if (!this.headerWritten) {
                this.writeHeader();
            }
            this.flushPendingStatements();
            this.writer.write("<!-- ");
            this.writer.write(comment);
            this.writer.write(" -->");
            this.writeNewLine();
        }
        catch (IOException e) {
            throw new RDFHandlerException((Throwable)e);
        }
    }

    protected void flushPendingStatements() throws IOException, RDFHandlerException {
        if (this.lastWrittenSubject != null) {
            this.writeEndTag("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "Description");
            this.writeNewLine();
            this.lastWrittenSubject = null;
        }
    }

    protected void writeStartOfStartTag(String namespace, String localName) throws IOException {
        if (namespace.equals(this.defaultNamespace)) {
            this.writer.write("<");
            this.writer.write(localName);
        } else {
            String prefix = this.namespaceTable.get(namespace);
            if (prefix == null) {
                this.writer.write("<");
                this.writer.write(localName);
                this.writer.write(" xmlns=\"");
                this.writer.write(XMLUtil.escapeDoubleQuotedAttValue((String)namespace));
                this.writer.write("\"");
            } else {
                this.writer.write("<");
                this.writer.write(prefix);
                this.writer.write(":");
                this.writer.write(localName);
            }
        }
    }

    protected void writeAttribute(String attName, String value) throws IOException {
        this.writer.write(" ");
        this.writer.write(attName);
        this.writer.write("=\"");
        this.writer.write(XMLUtil.escapeDoubleQuotedAttValue((String)value));
        this.writer.write("\"");
    }

    protected void writeAttribute(String namespace, String attName, String value) throws IOException, RDFHandlerException {
        String prefix = this.namespaceTable.get(namespace);
        if (prefix == null) {
            throw new RDFHandlerException("No prefix has been declared for the namespace used in this attribute: " + namespace);
        }
        this.writer.write(" ");
        this.writer.write(prefix);
        this.writer.write(":");
        this.writer.write(attName);
        this.writer.write("=\"");
        this.writer.write(XMLUtil.escapeDoubleQuotedAttValue((String)value));
        this.writer.write("\"");
    }

    protected void writeEndOfStartTag() throws IOException {
        this.writer.write(">");
    }

    protected void writeEndOfEmptyTag() throws IOException {
        this.writer.write("/>");
    }

    protected void writeEndTag(String namespace, String localName) throws IOException {
        if (namespace.equals(this.defaultNamespace)) {
            this.writer.write("</");
            this.writer.write(localName);
            this.writer.write(">");
        } else {
            this.writer.write("</");
            String prefix = this.namespaceTable.get(namespace);
            if (prefix != null) {
                this.writer.write(prefix);
                this.writer.write(":");
            }
            this.writer.write(localName);
            this.writer.write(">");
        }
    }

    protected void writeCharacterData(String chars) throws IOException {
        this.writer.write(XMLUtil.escapeCharacterData((String)chars));
    }

    protected void writeIndent() throws IOException {
        this.writer.write("\t");
    }

    protected void writeNewLine() throws IOException {
        this.writer.write("\n");
    }
}

