/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.rio.rdfjson;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Collection;
import java.util.HashSet;
import org.openrdf.model.Model;
import org.openrdf.model.Statement;
import org.openrdf.model.impl.TreeModel;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFWriter;
import org.openrdf.rio.RioSetting;
import org.openrdf.rio.helpers.BasicWriterSettings;
import org.openrdf.rio.helpers.RDFWriterBase;
import org.openrdf.rio.rdfjson.RDFJSONUtility;

public class RDFJSONWriter
extends RDFWriterBase
implements RDFWriter {
    private Writer writer;
    private OutputStream outputStream;
    private Model graph;
    private final RDFFormat actualFormat;

    public RDFJSONWriter(OutputStream out, RDFFormat actualFormat) {
        this.outputStream = out;
        this.actualFormat = actualFormat;
    }

    public RDFJSONWriter(Writer writer, RDFFormat actualFormat) {
        this.writer = writer;
        this.actualFormat = actualFormat;
    }

    public void endRDF() throws RDFHandlerException {
        block4: {
            try {
                if (this.writer != null) {
                    RDFJSONUtility.modelToRdfJson(this.graph, this.writer, this.getWriterConfig());
                    this.writer.flush();
                    break block4;
                }
                if (this.outputStream != null) {
                    RDFJSONUtility.modelToRdfJson(this.graph, this.outputStream, this.getWriterConfig());
                    this.outputStream.flush();
                    break block4;
                }
                throw new IllegalStateException("The output stream and the writer were both null.");
            }
            catch (IOException e) {
                throw new RDFHandlerException((Throwable)e);
            }
        }
    }

    public RDFFormat getRDFFormat() {
        return this.actualFormat;
    }

    public Collection<RioSetting<?>> getSupportedSettings() {
        HashSet results = new HashSet(super.getSupportedSettings());
        results.add(BasicWriterSettings.PRETTY_PRINT);
        return results;
    }

    public void handleComment(String comment) throws RDFHandlerException {
    }

    public void handleNamespace(String prefix, String uri) throws RDFHandlerException {
    }

    public void handleStatement(Statement statement) throws RDFHandlerException {
        this.graph.add((Object)statement);
    }

    public void startRDF() throws RDFHandlerException {
        this.graph = new TreeModel();
    }
}

