/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.rio.rdfjson;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Model;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.WriterConfig;
import org.openrdf.rio.helpers.BasicWriterSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDFJSONUtility {
    private static final String NULL = "null";
    private static final String GRAPHS = "graphs";
    private static final String URI = "uri";
    private static final String BNODE = "bnode";
    private static final String DATATYPE = "datatype";
    private static final String LITERAL = "literal";
    private static final String LANG = "lang";
    private static final String TYPE = "type";
    private static final String VALUE = "value";
    private static final JsonFactory JSON_FACTORY = new JsonFactory();
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public static void modelToRdfJson(Model graph, OutputStream writer) throws JsonGenerationException, IOException {
        RDFJSONUtility.modelToRdfJson(graph, writer, new WriterConfig());
    }

    public static void modelToRdfJson(Model graph, OutputStream writer, WriterConfig writerConfig) throws JsonGenerationException, IOException {
        JsonGenerator jg = JSON_FACTORY.createJsonGenerator(writer);
        RDFJSONUtility.modelToRdfJsonInternal(graph, writerConfig, jg);
        jg.close();
    }

    public static void modelToRdfJson(Model graph, Writer writer) throws JsonGenerationException, IOException {
        RDFJSONUtility.modelToRdfJson(graph, writer, new WriterConfig());
    }

    public static void modelToRdfJson(Model graph, Writer writer, WriterConfig writerConfig) throws JsonGenerationException, IOException {
        JsonGenerator jg = JSON_FACTORY.createJsonGenerator(writer);
        RDFJSONUtility.modelToRdfJsonInternal(graph, writerConfig, jg);
        jg.close();
    }

    private static void modelToRdfJsonInternal(Model graph, WriterConfig writerConfig, JsonGenerator jg) throws IOException, JsonGenerationException {
        if (((Boolean)writerConfig.get(BasicWriterSettings.PRETTY_PRINT)).booleanValue()) {
            jg.useDefaultPrettyPrinter();
        }
        jg.writeStartObject();
        for (Resource nextSubject : graph.subjects()) {
            jg.writeObjectFieldStart(RDFJSONUtility.resourceToString(nextSubject));
            for (URI nextPredicate : graph.filter(nextSubject, null, null, new Resource[0]).predicates()) {
                jg.writeArrayFieldStart(nextPredicate.stringValue());
                for (Value nextObject : graph.filter(nextSubject, nextPredicate, null, new Resource[0]).objects()) {
                    Set contexts = graph.filter(nextSubject, nextPredicate, nextObject, new Resource[0]).contexts();
                    RDFJSONUtility.writeObject(nextObject, contexts, jg);
                }
                jg.writeEndArray();
            }
            jg.writeEndObject();
        }
        jg.writeEndObject();
    }

    public static void rdfJsonToHandler(InputStream json, RDFHandler handler, ValueFactory vf) throws RDFParseException, RDFHandlerException {
        JsonParser jp = null;
        try {
            jp = JSON_FACTORY.createJsonParser(json);
            RDFJSONUtility.rdfJsonToHandlerInternal(handler, vf, jp);
        }
        catch (IOException e) {
            if (jp != null) {
                throw new RDFParseException((Throwable)e, jp.getCurrentLocation().getLineNr(), jp.getCurrentLocation().getColumnNr());
            }
            throw new RDFParseException((Throwable)e);
        }
        finally {
            if (jp != null) {
                try {
                    jp.close();
                }
                catch (IOException e) {
                    throw new RDFParseException("Found exception while closing JSON parser", (Throwable)e, jp.getCurrentLocation().getLineNr(), jp.getCurrentLocation().getColumnNr());
                }
            }
        }
    }

    public static void rdfJsonToHandler(Reader json, RDFHandler handler, ValueFactory vf) throws RDFParseException, RDFHandlerException {
        JsonParser jp = null;
        try {
            jp = JSON_FACTORY.createJsonParser(json);
            RDFJSONUtility.rdfJsonToHandlerInternal(handler, vf, jp);
        }
        catch (IOException e) {
            if (jp != null) {
                throw new RDFParseException((Throwable)e, jp.getCurrentLocation().getLineNr(), jp.getCurrentLocation().getColumnNr());
            }
            throw new RDFParseException((Throwable)e);
        }
        finally {
            if (jp != null) {
                try {
                    jp.close();
                }
                catch (IOException e) {
                    throw new RDFParseException("Found exception while closing JSON parser", (Throwable)e, jp.getCurrentLocation().getLineNr(), jp.getCurrentLocation().getColumnNr());
                }
            }
        }
    }

    private static void rdfJsonToHandlerInternal(RDFHandler handler, ValueFactory vf, JsonParser jp) throws IOException, JsonParseException, RDFParseException, RDFHandlerException {
        if (jp.nextToken() != JsonToken.START_OBJECT) {
            throw new RDFParseException("Expected RDF/JSON document to start with an Object", jp.getCurrentLocation().getLineNr(), jp.getCurrentLocation().getColumnNr());
        }
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String subjStr = jp.getCurrentName();
            URI subject = null;
            Object object = subject = subjStr.startsWith("_:") ? vf.createBNode(subjStr.substring(2)) : vf.createURI(subjStr);
            if (jp.nextToken() != JsonToken.START_OBJECT) {
                throw new RDFParseException("Expected subject value to start with an Object", jp.getCurrentLocation().getLineNr(), jp.getCurrentLocation().getColumnNr());
            }
            boolean foundPredicate = false;
            while (jp.nextToken() != JsonToken.END_OBJECT) {
                String predStr = jp.getCurrentName();
                URI predicate = vf.createURI(predStr);
                if (jp.nextToken() != JsonToken.START_ARRAY) {
                    throw new RDFParseException("Expected predicate value to start with an array", jp.getCurrentLocation().getLineNr(), jp.getCurrentLocation().getColumnNr());
                }
                foundPredicate = true;
                boolean foundObject = false;
                while (jp.nextToken() != JsonToken.END_ARRAY) {
                    if (jp.getCurrentToken() != JsonToken.START_OBJECT) {
                        throw new RDFParseException("Expected object value to start with an Object: subject=<" + subjStr + "> predicate=<" + predStr + ">", jp.getCurrentLocation().getLineNr(), jp.getCurrentLocation().getColumnNr());
                    }
                    String nextValue = null;
                    String nextType = null;
                    String nextDatatype = null;
                    String nextLanguage = null;
                    HashSet<String> nextContexts = new HashSet<String>(2);
                    while (jp.nextToken() != JsonToken.END_OBJECT) {
                        String fieldName = jp.getCurrentName();
                        if (VALUE.equals(fieldName)) {
                            if (nextValue != null) {
                                throw new RDFParseException("Multiple values found for a single object: subject=" + subjStr + " predicate=" + predStr, jp.getCurrentLocation().getLineNr(), jp.getCurrentLocation().getColumnNr());
                            }
                            jp.nextToken();
                            nextValue = jp.getText();
                            continue;
                        }
                        if (TYPE.equals(fieldName)) {
                            if (nextType != null) {
                                throw new RDFParseException("Multiple types found for single object: subject=" + subjStr + " predicate=" + predStr, jp.getCurrentLocation().getLineNr(), jp.getCurrentLocation().getColumnNr());
                            }
                            jp.nextToken();
                            nextType = jp.getText();
                            continue;
                        }
                        if (LANG.equals(fieldName)) {
                            if (nextLanguage != null) {
                                throw new RDFParseException("Multiple languages found for single object: subject=" + subjStr + " predicate=" + predStr, jp.getCurrentLocation().getLineNr(), jp.getCurrentLocation().getColumnNr());
                            }
                            jp.nextToken();
                            nextLanguage = jp.getText();
                            continue;
                        }
                        if (DATATYPE.equals(fieldName)) {
                            if (nextDatatype != null) {
                                throw new RDFParseException("Multiple datatypes found for single object: subject=" + subjStr + " predicate=" + predStr, jp.getCurrentLocation().getLineNr(), jp.getCurrentLocation().getColumnNr());
                            }
                            jp.nextToken();
                            nextDatatype = jp.getText();
                            continue;
                        }
                        if (GRAPHS.equals(fieldName)) {
                            if (jp.nextToken() != JsonToken.START_ARRAY) {
                                throw new RDFParseException("Expected graphs to start with an array", jp.getCurrentLocation().getLineNr(), jp.getCurrentLocation().getColumnNr());
                            }
                            while (jp.nextToken() != JsonToken.END_ARRAY) {
                                String nextGraph = jp.getText();
                                nextContexts.add(nextGraph);
                            }
                            continue;
                        }
                        throw new RDFParseException("Unrecognised JSON field name for object: subject=" + subjStr + " predicate=" + predStr + " fieldname=" + fieldName, jp.getCurrentLocation().getLineNr(), jp.getCurrentLocation().getColumnNr());
                    }
                    Literal object2 = null;
                    if (nextType == null) {
                        throw new RDFParseException("No type for object: subject=" + subjStr + " predicate=" + predStr, jp.getCurrentLocation().getLineNr(), jp.getCurrentLocation().getColumnNr());
                    }
                    if (nextValue == null) {
                        throw new RDFParseException("No value for object: subject=" + subjStr + " predicate=" + predStr, jp.getCurrentLocation().getLineNr(), jp.getCurrentLocation().getColumnNr());
                    }
                    if (LITERAL.equals(nextType)) {
                        object2 = nextLanguage != null ? vf.createLiteral(nextValue, nextLanguage) : (nextDatatype != null ? vf.createLiteral(nextValue, vf.createURI(nextDatatype)) : vf.createLiteral(nextValue));
                    } else if (BNODE.equals(nextType)) {
                        if (nextLanguage != null) {
                            throw new RDFParseException("Language was attached to a blank node object: subject=" + subjStr + " predicate=" + predStr, jp.getCurrentLocation().getLineNr(), jp.getCurrentLocation().getColumnNr());
                        }
                        if (nextDatatype != null) {
                            throw new RDFParseException("Datatype was attached to a blank node object: subject=" + subjStr + " predicate=" + predStr, jp.getCurrentLocation().getLineNr(), jp.getCurrentLocation().getColumnNr());
                        }
                        object2 = vf.createBNode(nextValue.substring(2));
                    } else if (URI.equals(nextType)) {
                        if (nextLanguage != null) {
                            throw new RDFParseException("Language was attached to a uri object: subject=" + subjStr + " predicate=" + predStr, jp.getCurrentLocation().getLineNr(), jp.getCurrentLocation().getColumnNr());
                        }
                        if (nextDatatype != null) {
                            throw new RDFParseException("Datatype was attached to a uri object: subject=" + subjStr + " predicate=" + predStr, jp.getCurrentLocation().getLineNr(), jp.getCurrentLocation().getColumnNr());
                        }
                        object2 = vf.createURI(nextValue);
                    }
                    if (!nextContexts.isEmpty()) {
                        for (String nextContext : nextContexts) {
                            URI context = nextContext.equals(NULL) ? null : vf.createURI(nextContext);
                            handler.handleStatement(vf.createStatement((Resource)subject, predicate, (Value)object2, (Resource)context));
                        }
                    } else {
                        handler.handleStatement(vf.createStatement((Resource)subject, predicate, (Value)object2));
                    }
                    foundObject = true;
                }
                if (foundObject) continue;
                throw new RDFParseException("No object for predicate: subject=" + subjStr + " predicate=" + predStr, jp.getCurrentLocation().getLineNr(), jp.getCurrentLocation().getColumnNr());
            }
            if (foundPredicate) continue;
            throw new RDFParseException("No predicate for object: subject=" + subjStr, jp.getCurrentLocation().getLineNr(), jp.getCurrentLocation().getColumnNr());
        }
    }

    private static String resourceToString(Resource uriOrBnode) {
        if (uriOrBnode instanceof URI) {
            return uriOrBnode.stringValue();
        }
        return "_:" + ((BNode)uriOrBnode).getID();
    }

    private static void writeObject(Value object, Set<Resource> contexts, JsonGenerator jg) throws JsonGenerationException, IOException {
        jg.writeStartObject();
        if (object instanceof Literal) {
            jg.writeObjectField(VALUE, (Object)object.stringValue());
            jg.writeObjectField(TYPE, (Object)LITERAL);
            Literal l = (Literal)object;
            if (l.getLanguage() != null) {
                jg.writeObjectField(LANG, (Object)l.getLanguage());
            }
            if (l.getDatatype() != null) {
                jg.writeObjectField(DATATYPE, (Object)l.getDatatype().stringValue());
            }
        } else if (object instanceof BNode) {
            jg.writeObjectField(VALUE, (Object)RDFJSONUtility.resourceToString((Resource)((BNode)object)));
            jg.writeObjectField(TYPE, (Object)BNODE);
        } else if (object instanceof URI) {
            jg.writeObjectField(VALUE, (Object)RDFJSONUtility.resourceToString((Resource)((URI)object)));
            jg.writeObjectField(TYPE, (Object)URI);
        }
        if (!(contexts == null || contexts.isEmpty() || contexts.size() == 1 && contexts.iterator().next() == null)) {
            jg.writeArrayFieldStart(GRAPHS);
            for (Resource nextContext : contexts) {
                if (nextContext == null) {
                    jg.writeNull();
                    continue;
                }
                jg.writeString(nextContext.stringValue());
            }
            jg.writeEndArray();
        }
        jg.writeEndObject();
    }

    static {
        JSON_FACTORY.disable(JsonFactory.Feature.INTERN_FIELD_NAMES);
        JSON_FACTORY.disable(JsonFactory.Feature.CANONICALIZE_FIELD_NAMES);
        JSON_FACTORY.disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
    }
}

