/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.rio.rdfjson;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.helpers.RDFParserBase;
import org.openrdf.rio.rdfjson.RDFJSONUtility;

public class RDFJSONParser
extends RDFParserBase
implements RDFParser {
    private final RDFFormat actualFormat;

    public RDFJSONParser() {
        this.actualFormat = RDFFormat.RDFJSON;
    }

    public RDFJSONParser(RDFFormat actualFormat) {
        this.actualFormat = actualFormat;
    }

    public RDFFormat getRDFFormat() {
        return this.actualFormat;
    }

    public void parse(InputStream inputStream, String baseUri) throws IOException, RDFParseException, RDFHandlerException {
        if (this.rdfHandler == null) {
            throw new IllegalStateException("RDF handler has not been set");
        }
        this.rdfHandler.startRDF();
        RDFJSONUtility.rdfJsonToHandler(inputStream, this.rdfHandler, this.valueFactory);
        this.rdfHandler.endRDF();
    }

    public void parse(Reader reader, String baseUri) throws IOException, RDFParseException, RDFHandlerException {
        if (this.rdfHandler == null) {
            throw new IllegalStateException("RDF handler has not been set");
        }
        this.rdfHandler.startRDF();
        RDFJSONUtility.rdfJsonToHandler(reader, this.rdfHandler, this.valueFactory);
        this.rdfHandler.endRDF();
    }
}

