/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.rio.nquads;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.helpers.NTriplesParserSettings;
import org.openrdf.rio.ntriples.NTriplesParser;

public class NQuadsParser
extends NTriplesParser {
    protected Resource context;

    public RDFFormat getRDFFormat() {
        return RDFFormat.NQUADS;
    }

    public synchronized void parse(InputStream inputStream, String baseURI) throws IOException, RDFParseException, RDFHandlerException {
        if (inputStream == null) {
            throw new IllegalArgumentException("Input stream can not be 'null'");
        }
        try {
            this.parse(new InputStreamReader(inputStream, "US-ASCII"), baseURI);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void parse(Reader reader, String baseURI) throws IOException, RDFParseException, RDFHandlerException {
        if (reader == null) {
            throw new IllegalArgumentException("Reader can not be 'null'");
        }
        if (baseURI == null) {
            throw new IllegalArgumentException("base URI can not be 'null'");
        }
        this.rdfHandler.startRDF();
        this.reader = reader;
        this.lineNo = 1;
        this.reportLocation(this.lineNo, 1);
        try {
            int c = reader.read();
            c = this.skipWhitespace(c);
            while (c != -1) {
                c = c == 35 ? this.skipLine(c) : (c == 13 || c == 10 ? this.skipLine(c) : this.parseQuad(c));
                c = this.skipWhitespace(c);
            }
        }
        finally {
            this.clear();
        }
        this.rdfHandler.endRDF();
    }

    private int parseQuad(int c) throws IOException, RDFParseException, RDFHandlerException {
        boolean ignoredAnError = false;
        try {
            c = this.parseSubject(c);
            c = this.skipWhitespace(c);
            c = this.parsePredicate(c);
            c = this.skipWhitespace(c);
            c = this.parseObject(c);
            c = this.skipWhitespace(c);
            if (c != 46) {
                c = this.parseContext(c);
                c = this.skipWhitespace(c);
            }
            if (c == -1) {
                this.throwEOFException();
            } else if (c != 46) {
                this.reportFatalError("Expected '.', found: " + (char)c);
            }
            c = this.assertLineTerminates(c);
        }
        catch (RDFParseException rdfpe) {
            if (((Boolean)this.getParserConfig().get(NTriplesParserSettings.IGNORE_NTRIPLES_INVALID_LINES)).booleanValue() || this.getParserConfig().isNonFatalError(NTriplesParserSettings.IGNORE_NTRIPLES_INVALID_LINES)) {
                ignoredAnError = true;
            }
            throw rdfpe;
        }
        c = this.skipLine(c);
        if (!ignoredAnError) {
            Statement st = this.createStatement(this.subject, this.predicate, this.object, this.context);
            this.rdfHandler.handleStatement(st);
        }
        this.subject = null;
        this.predicate = null;
        this.object = null;
        this.context = null;
        return c;
    }

    protected int parseContext(int c) throws IOException, RDFParseException {
        StringBuilder sb = new StringBuilder(100);
        if (c == 60) {
            c = this.parseUriRef(c, sb);
            this.context = this.createURI(sb.toString());
        } else if (c == 95) {
            c = this.parseNodeID(c, sb);
            this.context = this.createBNode(sb.toString());
        } else if (c == -1) {
            this.throwEOFException();
        } else {
            this.reportFatalError("Expected '<' or '_', found: " + (char)c);
        }
        return c;
    }
}

