/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.rio.binary;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFWriter;
import org.openrdf.rio.binary.BinaryRDFConstants;
import org.openrdf.rio.helpers.RDFWriterBase;

public class BinaryRDFWriter
extends RDFWriterBase
implements RDFWriter {
    private final BlockingQueue<Statement> statementQueue;
    private final Map<Value, AtomicInteger> valueFreq;
    private final Map<Value, Integer> valueIdentifiers;
    private final AtomicInteger maxValueId = new AtomicInteger(-1);
    private final DataOutputStream out;
    private boolean writingStarted = false;

    public BinaryRDFWriter(OutputStream out) {
        this(out, 100);
    }

    public BinaryRDFWriter(OutputStream out, int bufferSize) {
        this.out = new DataOutputStream(out);
        this.statementQueue = new ArrayBlockingQueue<Statement>(bufferSize);
        this.valueFreq = new HashMap<Value, AtomicInteger>(3 * bufferSize);
        this.valueIdentifiers = new LinkedHashMap<Value, Integer>(bufferSize);
    }

    public RDFFormat getRDFFormat() {
        return RDFFormat.BINARY;
    }

    public void startRDF() throws RDFHandlerException {
        if (!this.writingStarted) {
            this.writingStarted = true;
            try {
                this.out.write(BinaryRDFConstants.MAGIC_NUMBER);
                this.out.writeInt(1);
            }
            catch (IOException e) {
                throw new RDFHandlerException((Throwable)e);
            }
        }
    }

    public void endRDF() throws RDFHandlerException {
        this.startRDF();
        try {
            while (!this.statementQueue.isEmpty()) {
                this.writeStatement();
            }
            this.out.writeByte(127);
            this.out.flush();
            this.writingStarted = false;
        }
        catch (IOException e) {
            throw new RDFHandlerException((Throwable)e);
        }
    }

    public void handleNamespace(String prefix, String uri) throws RDFHandlerException {
        this.startRDF();
        try {
            this.out.writeByte(0);
            this.writeString(prefix);
            this.writeString(uri);
        }
        catch (IOException e) {
            throw new RDFHandlerException((Throwable)e);
        }
    }

    public void handleComment(String comment) throws RDFHandlerException {
        this.startRDF();
        try {
            this.out.writeByte(2);
            this.writeString(comment);
        }
        catch (IOException e) {
            throw new RDFHandlerException((Throwable)e);
        }
    }

    public void handleStatement(Statement st) throws RDFHandlerException {
        this.statementQueue.add(st);
        this.incValueFreq((Value)st.getSubject());
        this.incValueFreq((Value)st.getPredicate());
        this.incValueFreq(st.getObject());
        this.incValueFreq((Value)st.getContext());
        if (this.statementQueue.remainingCapacity() > 0) {
            return;
        }
        this.startRDF();
        try {
            this.writeStatement();
        }
        catch (IOException e) {
            throw new RDFHandlerException((Throwable)e);
        }
    }

    private void writeStatement() throws RDFHandlerException, IOException {
        Statement st = (Statement)this.statementQueue.remove();
        int subjId = this.getValueId((Value)st.getSubject());
        int predId = this.getValueId((Value)st.getPredicate());
        int objId = this.getValueId(st.getObject());
        int contextId = this.getValueId((Value)st.getContext());
        this.decValueFreq((Value)st.getSubject());
        this.decValueFreq((Value)st.getPredicate());
        this.decValueFreq(st.getObject());
        this.decValueFreq((Value)st.getContext());
        this.out.writeByte(1);
        this.writeValueOrId((Value)st.getSubject(), subjId);
        this.writeValueOrId((Value)st.getPredicate(), predId);
        this.writeValueOrId(st.getObject(), objId);
        this.writeValueOrId((Value)st.getContext(), contextId);
    }

    private void incValueFreq(Value v) {
        if (v != null) {
            AtomicInteger freq = this.valueFreq.get(v);
            if (freq != null) {
                freq.incrementAndGet();
            } else {
                this.valueFreq.put(v, new AtomicInteger(1));
            }
        }
    }

    private void decValueFreq(Value v) {
        int newFreq;
        AtomicInteger freq;
        if (v != null && (freq = this.valueFreq.get(v)) != null && (newFreq = freq.decrementAndGet()) == 0) {
            this.valueFreq.remove(v);
        }
    }

    private int getValueId(Value v) throws IOException, RDFHandlerException {
        AtomicInteger freq;
        if (v == null) {
            return -1;
        }
        Integer id = this.valueIdentifiers.get(v);
        if (id == null && (freq = this.valueFreq.get(v)) != null && freq.get() >= 2) {
            id = this.assignValueId(v);
        }
        if (id != null) {
            return id;
        }
        return -1;
    }

    private Integer assignValueId(Value v) throws IOException, RDFHandlerException {
        Integer id = null;
        for (Value key : this.valueIdentifiers.keySet()) {
            if (this.valueFreq.containsKey(key)) continue;
            id = this.valueIdentifiers.remove(key);
            break;
        }
        if (id == null) {
            id = this.maxValueId.incrementAndGet();
        }
        this.out.writeByte(3);
        this.out.writeInt(id);
        this.writeValue(v);
        this.valueIdentifiers.put(v, id);
        return id;
    }

    private void writeValueOrId(Value value, int id) throws RDFHandlerException, IOException {
        if (value == null) {
            this.out.writeByte(0);
        } else if (id >= 0) {
            this.out.writeByte(6);
            this.out.writeInt(id);
        } else {
            this.writeValue(value);
        }
    }

    private void writeValue(Value value) throws RDFHandlerException, IOException {
        if (value instanceof URI) {
            this.writeURI((URI)value);
        } else if (value instanceof BNode) {
            this.writeBNode((BNode)value);
        } else if (value instanceof Literal) {
            this.writeLiteral((Literal)value);
        } else {
            throw new RDFHandlerException("Unknown Value object type: " + value.getClass());
        }
    }

    private void writeURI(URI uri) throws IOException {
        this.out.writeByte(1);
        this.writeString(uri.toString());
    }

    private void writeBNode(BNode bnode) throws IOException {
        this.out.writeByte(2);
        this.writeString(bnode.getID());
    }

    private void writeLiteral(Literal literal) throws IOException {
        String label = literal.getLabel();
        String language = literal.getLanguage();
        URI datatype = literal.getDatatype();
        if (language != null) {
            this.out.writeByte(4);
            this.writeString(label);
            this.writeString(language);
        } else if (datatype != null) {
            this.out.writeByte(5);
            this.writeString(label);
            this.writeString(datatype.toString());
        } else {
            this.out.writeByte(3);
            this.writeString(label);
        }
    }

    private void writeString(String s) throws IOException {
        this.out.writeInt(s.length());
        this.out.writeChars(s);
    }
}

