/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.rio;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.openrdf.rio.ParserSetting;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.helpers.BasicParserSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParserConfig
implements Serializable {
    private static final long serialVersionUID = 270L;
    protected final ConcurrentMap<ParserSetting<Object>, Object> settings = new ConcurrentHashMap<ParserSetting<Object>, Object>();
    protected final Logger log = LoggerFactory.getLogger(ParserConfig.class);

    public ParserConfig() {
    }

    public ParserConfig(boolean verifyData, boolean stopAtFirstError, boolean preserveBNodeIDs, RDFParser.DatatypeHandling datatypeHandling) {
        this.set(BasicParserSettings.VERIFY_DATA, verifyData);
        this.set(BasicParserSettings.STOP_AT_FIRST_ERROR, stopAtFirstError);
        this.set(BasicParserSettings.PRESERVE_BNODE_IDS, preserveBNodeIDs);
        this.set(BasicParserSettings.DATATYPE_HANDLING, datatypeHandling);
    }

    public boolean verifyData() {
        return this.get(BasicParserSettings.VERIFY_DATA);
    }

    public boolean stopAtFirstError() {
        return this.get(BasicParserSettings.STOP_AT_FIRST_ERROR);
    }

    public boolean isPreserveBNodeIDs() {
        return this.get(BasicParserSettings.PRESERVE_BNODE_IDS);
    }

    public RDFParser.DatatypeHandling datatypeHandling() {
        return this.get(BasicParserSettings.DATATYPE_HANDLING);
    }

    public <T> T get(ParserSetting<T> setting) {
        Object result = this.settings.get(setting);
        if (result == null) {
            return setting.getDefaultValue();
        }
        return (T)result;
    }

    public <T> void set(ParserSetting<T> setting, T value) {
        if (value == null) {
            this.settings.remove(setting);
        } else {
            Object putIfAbsent = this.settings.putIfAbsent(setting, value);
            if (putIfAbsent != null) {
                this.settings.put(setting, value);
                this.log.trace("Overriding previous setting for {}", (Object)setting.getKey());
            }
        }
    }

    public <T> boolean isSet(ParserSetting<T> setting) {
        return this.settings.containsKey(setting);
    }
}

