/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.sparql.query;

import java.io.IOException;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.PostMethod;
import org.openrdf.model.URI;
import org.openrdf.query.Dataset;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.Update;
import org.openrdf.query.UpdateExecutionException;
import org.openrdf.repository.sparql.SPARQLRepository;
import org.openrdf.repository.sparql.query.SPARQLOperation;

public class SPARQLUpdate
extends SPARQLOperation
implements Update {
    public SPARQLUpdate(HttpClient client, String url, String base, String operation) {
        super(client, url, base, operation);
    }

    public void execute() throws UpdateExecutionException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpMethodBase getResponse() throws HttpException, IOException, QueryEvaluationException {
        PostMethod post = new PostMethod(this.getUrl());
        post.addParameter("update", this.getQueryString());
        Dataset dataset = this.getDataset();
        if (dataset != null) {
            for (URI graph : dataset.getDefaultGraphs()) {
                post.addParameter("default-graph-uri", String.valueOf(graph));
            }
            for (URI graph : dataset.getNamedGraphs()) {
                post.addParameter("named-graph-uri", String.valueOf(graph));
            }
        }
        post.addRequestHeader("Content-type", "application/x-sparql-update");
        Map additionalHeaders = (Map)this.client.getParams().getParameter(SPARQLRepository.ADDITIONAL_HEADER_NAME);
        if (additionalHeaders != null) {
            for (Map.Entry additionalHeader : additionalHeaders.entrySet()) {
                post.addRequestHeader((String)additionalHeader.getKey(), (String)additionalHeader.getValue());
            }
        }
        boolean completed = false;
        try {
            if (this.client.executeMethod((HttpMethod)post) >= 400) {
                throw new QueryEvaluationException(post.getResponseBodyAsString());
            }
            completed = true;
            PostMethod postMethod = post;
            return postMethod;
        }
        finally {
            if (!completed) {
                post.abort();
            }
        }
    }
}

