/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.sparql.query;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.Set;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HeaderElement;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.openrdf.query.GraphQuery;
import org.openrdf.query.GraphQueryResult;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.resultio.UnsupportedQueryResultFormatException;
import org.openrdf.repository.sparql.query.BackgroundGraphResult;
import org.openrdf.repository.sparql.query.SPARQLQuery;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.RDFParserFactory;
import org.openrdf.rio.RDFParserRegistry;

public class SPARQLGraphQuery
extends SPARQLQuery
implements GraphQuery {
    private RDFParserRegistry registry = RDFParserRegistry.getInstance();

    public SPARQLGraphQuery(HttpClient client, String url, String base, String query) {
        super(client, url, base, query);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public GraphQueryResult evaluate() throws QueryEvaluationException {
        try {
            BackgroundGraphResult result = null;
            HttpMethodBase response = this.getResponse();
            try {
                Charset charset;
                RDFParser parser = this.getParser((HttpMethod)response);
                InputStream in = response.getResponseBodyAsStream();
                String charset_str = response.getResponseCharSet();
                try {
                    charset = Charset.forName(charset_str);
                }
                catch (IllegalCharsetNameException e) {
                    charset = Charset.forName("UTF-8");
                }
                result = new BackgroundGraphResult(parser, in, charset, this.getUrl(), (HttpMethod)response);
                this.execute(result);
                BackgroundGraphResult backgroundGraphResult = result;
                return backgroundGraphResult;
            }
            catch (HttpException e) {
                throw new QueryEvaluationException((Throwable)e);
            }
            finally {
                if (result == null) {
                    response.abort();
                    response.releaseConnection();
                }
            }
        }
        catch (IOException e) {
            throw new QueryEvaluationException((Throwable)e);
        }
    }

    public void evaluate(RDFHandler handler) throws QueryEvaluationException, RDFHandlerException {
        boolean complete = false;
        try {
            HttpMethodBase response = this.getResponse();
            try {
                RDFParser parser = this.getParser((HttpMethod)response);
                parser.setRDFHandler(handler);
                parser.parse(response.getResponseBodyAsStream(), this.getUrl());
                complete = true;
            }
            catch (HttpException e) {
                throw new QueryEvaluationException((Throwable)e);
            }
            catch (RDFParseException e) {
                throw new QueryEvaluationException((Throwable)e);
            }
            catch (RDFHandlerException e) {
                throw new QueryEvaluationException((Throwable)e);
            }
            finally {
                if (!complete) {
                    response.abort();
                }
            }
        }
        catch (IOException e) {
            throw new QueryEvaluationException((Throwable)e);
        }
    }

    protected String getAccept() {
        StringBuilder sb = new StringBuilder();
        Set rdfFormats = this.registry.getKeys();
        for (RDFFormat format : rdfFormats) {
            for (String mimeType : format.getMIMETypes()) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(mimeType);
            }
        }
        return sb.toString();
    }

    private RDFParser getParser(HttpMethod response) {
        for (Header header : response.getResponseHeaders("Content-Type")) {
            for (HeaderElement headerEl : header.getElements()) {
                RDFFormat format;
                RDFParserFactory factory;
                String mimeType = headerEl.getName();
                if (mimeType == null || (factory = (RDFParserFactory)this.registry.get((Object)(format = (RDFFormat)this.registry.getFileFormatForMIMEType(mimeType)))) == null) continue;
                return factory.getParser();
            }
        }
        throw new UnsupportedQueryResultFormatException("No parser factory available for this graph query result format");
    }
}

