/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.sparql.query;

import java.io.IOException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethodBase;
import org.openrdf.query.BooleanQuery;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.resultio.QueryResultParseException;
import org.openrdf.query.resultio.sparqlxml.SPARQLBooleanXMLParser;
import org.openrdf.repository.sparql.query.SPARQLQuery;

public class SPARQLBooleanQuery
extends SPARQLQuery
implements BooleanQuery {
    private SPARQLBooleanXMLParser parser = new SPARQLBooleanXMLParser();

    public SPARQLBooleanQuery(HttpClient client, String url, String base, String query) {
        super(client, url, base, query);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean evaluate() throws QueryEvaluationException {
        try {
            boolean complete = false;
            HttpMethodBase response = this.getResponse();
            try {
                boolean result = this.parser.parse(response.getResponseBodyAsStream());
                response.releaseConnection();
                complete = true;
                boolean bl = result;
                return bl;
            }
            catch (HttpException e) {
                throw new QueryEvaluationException((Throwable)e);
            }
            catch (QueryResultParseException e) {
                throw new QueryEvaluationException((Throwable)e);
            }
            finally {
                if (!complete) {
                    response.abort();
                    response.releaseConnection();
                }
            }
        }
        catch (IOException e) {
            throw new QueryEvaluationException((Throwable)e);
        }
    }

    protected String getAccept() {
        return this.parser.getBooleanQueryResultFormat().getDefaultMIMEType();
    }
}

