/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.sparql;

import info.aduna.io.MavenUtil;
import java.io.File;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.base.RepositoryBase;
import org.openrdf.repository.sparql.SPARQLConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SPARQLRepository
extends RepositoryBase {
    private static final String APP_NAME = "OpenRDF.org SPARQLConnection";
    private static final String VERSION = MavenUtil.loadVersion((String)"org.openrdf.sesame", (String)"sesame-repository-sparql", (String)"devel");
    public static String ADDITIONAL_HEADER_NAME = "additionalHTTPHeaders";
    private String queryEndpointUrl;
    private String updateEndpointUrl;
    private Map<String, String> additionalHttpHeaders;
    private HttpClient client;
    private MultiThreadedHttpConnectionManager manager;

    public SPARQLRepository(String queryEndpointUrl) {
        this.queryEndpointUrl = queryEndpointUrl;
    }

    public SPARQLRepository(String queryEndpointUrl, String updateEndpointUrl) {
        this.queryEndpointUrl = queryEndpointUrl;
        this.updateEndpointUrl = updateEndpointUrl;
    }

    public RepositoryConnection getConnection() throws RepositoryException {
        if (!this.isInitialized()) {
            throw new RepositoryException("SPARQLRepository not initialized.");
        }
        return new SPARQLConnection(this, this.queryEndpointUrl, this.updateEndpointUrl);
    }

    public File getDataDir() {
        return null;
    }

    public ValueFactory getValueFactory() {
        return ValueFactoryImpl.getInstance();
    }

    protected void initializeInternal() throws RepositoryException {
        this.manager = new MultiThreadedHttpConnectionManager();
        HttpConnectionManagerParams params = new HttpConnectionManagerParams();
        params.setDefaultMaxConnectionsPerHost(20);
        this.manager.setParams(params);
        HttpClientParams clientParams = new HttpClientParams();
        clientParams.setParameter("http.useragent", (Object)("OpenRDF.org SPARQLConnection/" + VERSION + " " + clientParams.getParameter("http.useragent")));
        if (this.getAdditionalHttpHeaders() != null) {
            clientParams.setParameter(ADDITIONAL_HEADER_NAME, this.getAdditionalHttpHeaders());
        }
        this.client = new HttpClient(clientParams, (HttpConnectionManager)this.manager);
    }

    public boolean isWritable() throws RepositoryException {
        return false;
    }

    public void setDataDir(File dataDir) {
    }

    public HttpClient getHttpClient() {
        return this.client;
    }

    protected void shutDownInternal() throws RepositoryException {
        if (this.manager != null) {
            this.manager.shutdown();
        }
    }

    public String toString() {
        return this.queryEndpointUrl;
    }

    public Map<String, String> getAdditionalHttpHeaders() {
        return this.additionalHttpHeaders;
    }

    public void setAdditionalHttpHeaders(Map<String, String> additionalHttpHeaders) {
        this.additionalHttpHeaders = additionalHttpHeaders;
    }
}

