/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.sparql;

import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.ConvertingIteration;
import info.aduna.iteration.EmptyIteration;
import info.aduna.iteration.ExceptionConvertingIteration;
import info.aduna.iteration.Iteration;
import info.aduna.iteration.SingletonIteration;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import org.apache.commons.httpclient.HttpClient;
import org.openrdf.model.Literal;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.StatementImpl;
import org.openrdf.query.BindingSet;
import org.openrdf.query.BooleanQuery;
import org.openrdf.query.Dataset;
import org.openrdf.query.GraphQuery;
import org.openrdf.query.GraphQueryResult;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.Query;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.UnsupportedQueryLanguageException;
import org.openrdf.query.Update;
import org.openrdf.query.UpdateExecutionException;
import org.openrdf.query.impl.DatasetImpl;
import org.openrdf.query.parser.QueryParserUtil;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;
import org.openrdf.repository.UnknownTransactionStateException;
import org.openrdf.repository.base.RepositoryConnectionBase;
import org.openrdf.repository.sparql.SPARQLRepository;
import org.openrdf.repository.sparql.query.SPARQLBooleanQuery;
import org.openrdf.repository.sparql.query.SPARQLGraphQuery;
import org.openrdf.repository.sparql.query.SPARQLTupleQuery;
import org.openrdf.repository.sparql.query.SPARQLUpdate;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SPARQLConnection
extends RepositoryConnectionBase {
    private static final String EVERYTHING = "CONSTRUCT { ?s ?p ?o } WHERE { ?s ?p ?o }";
    private static final String SOMETHING = "ASK { ?s ?p ?o }";
    private static final String NAMEDGRAPHS = "SELECT DISTINCT ?_ WHERE { GRAPH ?_ { ?s ?p ?o } }";
    private final HttpClient client;
    private String queryEndpointUrl;
    private String updateEndpointUrl;

    public SPARQLConnection(SPARQLRepository repository, String queryEndpointUrl, String updateEndpointUrl) {
        super((Repository)repository);
        this.queryEndpointUrl = queryEndpointUrl;
        this.updateEndpointUrl = updateEndpointUrl;
        this.client = repository.getHttpClient();
    }

    public String toString() {
        return this.queryEndpointUrl;
    }

    public void exportStatements(Resource subj, URI pred, Value obj, boolean includeInferred, RDFHandler handler, Resource ... contexts) throws RepositoryException, RDFHandlerException {
        try {
            GraphQuery query = this.prepareGraphQuery(QueryLanguage.SPARQL, EVERYTHING, "");
            this.setBindings((Query)query, subj, pred, obj, contexts);
            query.evaluate(handler);
        }
        catch (MalformedQueryException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (QueryEvaluationException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public RepositoryResult<Resource> getContextIDs() throws RepositoryException {
        try {
            TupleQuery query = this.prepareTupleQuery(QueryLanguage.SPARQL, NAMEDGRAPHS, "");
            TupleQueryResult result = query.evaluate();
            return new RepositoryResult((CloseableIteration)new ExceptionConvertingIteration<Resource, RepositoryException>((Iteration)new ConvertingIteration<BindingSet, Resource, QueryEvaluationException>((Iteration)result){

                protected Resource convert(BindingSet bindings) throws QueryEvaluationException {
                    return (Resource)bindings.getValue("_");
                }
            }){

                protected RepositoryException convert(Exception e) {
                    return new RepositoryException((Throwable)e);
                }
            });
        }
        catch (MalformedQueryException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (QueryEvaluationException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public String getNamespace(String prefix) throws RepositoryException {
        return null;
    }

    public RepositoryResult<Namespace> getNamespaces() throws RepositoryException {
        return new RepositoryResult((CloseableIteration)new EmptyIteration());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long size(Resource ... contexts) throws RepositoryException {
        RepositoryResult<Statement> stmts = this.getStatements(null, null, null, true, contexts);
        try {
            long i = 0L;
            while (stmts.hasNext()) {
                stmts.next();
                ++i;
            }
            long l = i;
            return l;
        }
        finally {
            stmts.close();
        }
    }

    public RepositoryResult<Statement> getStatements(Resource subj, URI pred, Value obj, boolean includeInferred, Resource ... contexts) throws RepositoryException {
        try {
            if (subj != null && pred != null && obj != null) {
                if (this.hasStatement(subj, pred, obj, includeInferred, contexts)) {
                    StatementImpl st = new StatementImpl(subj, pred, obj);
                    SingletonIteration cursor = new SingletonIteration((Object)st);
                    return new RepositoryResult((CloseableIteration)cursor);
                }
                return new RepositoryResult((CloseableIteration)new EmptyIteration());
            }
            GraphQuery query = this.prepareGraphQuery(QueryLanguage.SPARQL, EVERYTHING, "");
            this.setBindings((Query)query, subj, pred, obj, contexts);
            GraphQueryResult result = query.evaluate();
            return new RepositoryResult((CloseableIteration)new ExceptionConvertingIteration<Statement, RepositoryException>((Iteration)result){

                protected RepositoryException convert(Exception e) {
                    return new RepositoryException((Throwable)e);
                }
            });
        }
        catch (MalformedQueryException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (QueryEvaluationException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public boolean hasStatement(Resource subj, URI pred, Value obj, boolean includeInferred, Resource ... contexts) throws RepositoryException {
        try {
            BooleanQuery query = this.prepareBooleanQuery(QueryLanguage.SPARQL, SOMETHING, "");
            this.setBindings((Query)query, subj, pred, obj, contexts);
            return query.evaluate();
        }
        catch (MalformedQueryException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (QueryEvaluationException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public Query prepareQuery(QueryLanguage ql, String query, String base) throws RepositoryException, MalformedQueryException {
        if (QueryLanguage.SPARQL.equals((Object)ql)) {
            String strippedQuery = QueryParserUtil.removeSPARQLQueryProlog((String)query).toUpperCase();
            if (strippedQuery.startsWith("SELECT")) {
                return this.prepareTupleQuery(ql, query, base);
            }
            if (strippedQuery.startsWith("ASK")) {
                return this.prepareBooleanQuery(ql, query, base);
            }
            return this.prepareGraphQuery(ql, query, base);
        }
        throw new UnsupportedOperationException("Unsupported query language " + ql);
    }

    public BooleanQuery prepareBooleanQuery(QueryLanguage ql, String query, String base) throws RepositoryException, MalformedQueryException {
        if (QueryLanguage.SPARQL.equals((Object)ql)) {
            return new SPARQLBooleanQuery(this.client, this.queryEndpointUrl, base, query);
        }
        throw new UnsupportedQueryLanguageException("Unsupported query language " + ql);
    }

    public GraphQuery prepareGraphQuery(QueryLanguage ql, String query, String base) throws RepositoryException, MalformedQueryException {
        if (QueryLanguage.SPARQL.equals((Object)ql)) {
            return new SPARQLGraphQuery(this.client, this.queryEndpointUrl, base, query);
        }
        throw new UnsupportedQueryLanguageException("Unsupported query language " + ql);
    }

    public TupleQuery prepareTupleQuery(QueryLanguage ql, String query, String base) throws RepositoryException, MalformedQueryException {
        if (QueryLanguage.SPARQL.equals((Object)ql)) {
            return new SPARQLTupleQuery(this.client, this.queryEndpointUrl, base, query);
        }
        throw new UnsupportedQueryLanguageException("Unsupported query language " + ql);
    }

    public void commit() throws RepositoryException {
    }

    @Deprecated
    public boolean isAutoCommit() throws RepositoryException {
        return true;
    }

    public void rollback() throws RepositoryException {
    }

    public void begin() throws RepositoryException {
    }

    @Deprecated
    public void setAutoCommit(boolean autoCommit) throws RepositoryException {
        if (!autoCommit) {
            throw new UnsupportedOperationException();
        }
    }

    public void add(Statement st, Resource ... contexts) throws RepositoryException {
        ArrayList<Statement> list = new ArrayList<Statement>(1);
        list.add(st);
        String sparqlCommand = this.createInsertDataCommand(list, contexts);
        try {
            Update update = this.prepareUpdate(QueryLanguage.SPARQL, sparqlCommand);
            update.execute();
        }
        catch (MalformedQueryException e) {
            throw new RuntimeException("unexpected error creating SPARQL update command", e);
        }
        catch (UpdateExecutionException e) {
            throw new RepositoryException("error executing update", (Throwable)e);
        }
    }

    public void add(Iterable<? extends Statement> statements, Resource ... contexts) throws RepositoryException {
        String sparqlCommand = this.createInsertDataCommand(statements, contexts);
        try {
            Update update = this.prepareUpdate(QueryLanguage.SPARQL, sparqlCommand);
            update.execute();
        }
        catch (MalformedQueryException e) {
            throw new RuntimeException("unexpected error creating SPARQL update command", e);
        }
        catch (UpdateExecutionException e) {
            throw new RepositoryException("error executing update", (Throwable)e);
        }
    }

    public <E extends Exception> void add(Iteration<? extends Statement, E> statementIter, Resource ... contexts) throws RepositoryException, E {
        throw new UnsupportedOperationException();
    }

    public void add(InputStream in, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void add(Reader reader, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void add(URL url, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void add(File file, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void add(Resource subject, URI predicate, Value object, Resource ... contexts) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void clear(Resource ... contexts) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void clearNamespaces() throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void remove(Statement st, Resource ... contexts) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void remove(Iterable<? extends Statement> statements, Resource ... contexts) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public <E extends Exception> void remove(Iteration<? extends Statement, E> statementIter, Resource ... contexts) throws RepositoryException, E {
        throw new UnsupportedOperationException();
    }

    public void remove(Resource subject, URI predicate, Value object, Resource ... contexts) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void removeNamespace(String prefix) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void setNamespace(String prefix, String name) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public Update prepareUpdate(QueryLanguage ql, String update, String baseURI) throws RepositoryException, MalformedQueryException {
        if (QueryLanguage.SPARQL.equals((Object)ql)) {
            return new SPARQLUpdate(this.client, this.queryEndpointUrl, baseURI, update);
        }
        throw new UnsupportedQueryLanguageException("Unsupported query language " + ql);
    }

    private void setBindings(Query query, Resource subj, URI pred, Value obj, Resource ... contexts) throws RepositoryException {
        if (subj != null) {
            query.setBinding("s", (Value)subj);
        }
        if (pred != null) {
            query.setBinding("p", (Value)pred);
        }
        if (obj != null) {
            query.setBinding("o", obj);
        }
        if (contexts != null && contexts.length > 0 && (contexts[0] != null || contexts.length > 1)) {
            DatasetImpl dataset = new DatasetImpl();
            for (Resource ctx : contexts) {
                if (!(ctx instanceof URI)) {
                    throw new RepositoryException("Contexts must be URIs");
                }
                dataset.addDefaultGraph((URI)ctx);
            }
            query.setDataset((Dataset)dataset);
        }
    }

    protected void addWithoutCommit(Resource subject, URI predicate, Value object, Resource ... contexts) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    protected void removeWithoutCommit(Resource subject, URI predicate, Value object, Resource ... contexts) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    private String createInsertDataCommand(Iterable<? extends Statement> statements, Resource ... contexts) {
        StringBuilder qb = new StringBuilder();
        qb.append("INSERT DATA \n");
        qb.append("{ \n");
        if (contexts != null) {
            for (Resource context : contexts) {
                if (context != null) {
                    qb.append("    GRAPH <" + context.stringValue() + "> { \n");
                }
                this.createDataBody(qb, statements);
                if (context == null) continue;
                qb.append(" } \n");
            }
        } else {
            this.createDataBody(qb, statements);
        }
        qb.append("}");
        return qb.toString();
    }

    private void createDataBody(StringBuilder qb, Iterable<? extends Statement> statements) {
        for (Statement statement : statements) {
            qb.append("<" + statement.getSubject().stringValue() + "> ");
            qb.append("<" + statement.getPredicate().stringValue() + "> ");
            if (statement.getObject() instanceof Literal) {
                qb.append(statement.getObject().stringValue() + " ");
            } else {
                qb.append("<" + statement.getObject().stringValue() + "> ");
            }
            qb.append(". \n");
        }
    }

    public boolean isActive() throws UnknownTransactionStateException, RepositoryException {
        return false;
    }
}

