/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.http;

import java.io.IOException;
import java.util.Iterator;
import org.openrdf.http.client.HTTPClient;
import org.openrdf.http.protocol.UnauthorizedException;
import org.openrdf.query.Binding;
import org.openrdf.query.BindingSet;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryInterruptedException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.UpdateExecutionException;
import org.openrdf.query.impl.AbstractUpdate;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.http.HTTPRepositoryConnection;
import org.openrdf.repository.http.HTTPUpdateExecutionException;

public class HTTPUpdate
extends AbstractUpdate {
    protected final HTTPRepositoryConnection httpCon;
    private final QueryLanguage queryLanguage;
    private final String queryString;
    private final String baseURI;

    public HTTPUpdate(HTTPRepositoryConnection con, QueryLanguage ql, String queryString, String baseURI) {
        this.httpCon = con;
        this.queryLanguage = ql;
        this.queryString = queryString;
        this.baseURI = baseURI;
    }

    protected Binding[] getBindingsArray() {
        BindingSet bindings = this.getBindings();
        Binding[] bindingsArray = new Binding[bindings.size()];
        Iterator iter = bindings.iterator();
        for (int i = 0; i < bindings.size(); ++i) {
            bindingsArray[i] = (Binding)iter.next();
        }
        return bindingsArray;
    }

    public String toString() {
        return this.getQueryString();
    }

    public void execute() throws UpdateExecutionException {
        block8: {
            try {
                if (this.httpCon.isAutoCommit()) {
                    HTTPClient client = this.httpCon.getRepository().getHTTPClient();
                    try {
                        client.sendUpdate(this.getQueryLanguage(), this.getQueryString(), this.getBaseURI(), this.dataset, this.includeInferred, this.getBindingsArray());
                        break block8;
                    }
                    catch (UnauthorizedException e) {
                        throw new HTTPUpdateExecutionException(e.getMessage(), e);
                    }
                    catch (QueryInterruptedException e) {
                        throw new HTTPUpdateExecutionException(e.getMessage(), e);
                    }
                    catch (MalformedQueryException e) {
                        throw new HTTPUpdateExecutionException(e.getMessage(), e);
                    }
                    catch (IOException e) {
                        throw new HTTPUpdateExecutionException(e.getMessage(), e);
                    }
                }
                this.httpCon.scheduleUpdate(this);
            }
            catch (RepositoryException e) {
                throw new HTTPUpdateExecutionException(e.getMessage(), e);
            }
        }
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public QueryLanguage getQueryLanguage() {
        return this.queryLanguage;
    }

    public String getQueryString() {
        return this.queryString;
    }
}

