/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.http;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.openrdf.http.client.HTTPClient;
import org.openrdf.http.protocol.UnauthorizedException;
import org.openrdf.query.Binding;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryInterruptedException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.query.TupleQueryResultHandlerException;
import org.openrdf.query.impl.TupleQueryResultImpl;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.http.QueueCursor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTTPTupleQueryResult
extends TupleQueryResultImpl
implements Runnable,
TupleQueryResultHandler {
    private volatile boolean closed;
    private volatile Thread parserThread;
    private HTTPClient httpClient;
    private QueueCursor<BindingSet> queue;
    private List<String> bindingNames;
    private CountDownLatch bindingNamesReady = new CountDownLatch(1);
    private QueryLanguage queryLanguage;
    private String queryString;
    private Dataset dataset;
    private boolean includeInferred;
    private Binding[] bindings;
    private String baseURI;

    public HTTPTupleQueryResult(HTTPClient httpClient, QueryLanguage ql, String queryString, String baseURI, Dataset dataset, boolean includeInferred, Binding ... bindings) {
        this(new QueueCursor<BindingSet>(10), httpClient, ql, queryString, baseURI, dataset, includeInferred, bindings);
    }

    public HTTPTupleQueryResult(QueueCursor<BindingSet> queue, HTTPClient httpClient, QueryLanguage ql, String queryString, String baseURI, Dataset dataset, boolean includeInferred, Binding ... bindings) {
        super(Collections.emptyList(), queue);
        this.queue = queue;
        this.httpClient = httpClient;
        this.queryLanguage = ql;
        this.queryString = queryString;
        this.baseURI = baseURI;
        this.dataset = dataset;
        this.includeInferred = includeInferred;
        this.bindings = bindings;
    }

    public List<String> getBindingNames() {
        try {
            this.bindingNamesReady.await();
            this.queue.checkException();
            return this.bindingNames;
        }
        catch (InterruptedException e) {
            throw new UndeclaredThrowableException(e);
        }
        catch (QueryEvaluationException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.parserThread = Thread.currentThread();
        try {
            this.httpClient.sendTupleQuery(this.queryLanguage, this.queryString, this.baseURI, this.dataset, this.includeInferred, 0, (TupleQueryResultHandler)this, this.bindings);
        }
        catch (TupleQueryResultHandlerException e) {
        }
        catch (IOException e) {
            this.queue.toss(e);
        }
        catch (UnauthorizedException e) {
            this.queue.toss((Exception)((Object)e));
        }
        catch (QueryInterruptedException e) {
            this.queue.toss((Exception)((Object)e));
        }
        catch (RepositoryException e) {
            this.queue.toss((Exception)((Object)e));
        }
        catch (MalformedQueryException e) {
            this.queue.toss((Exception)((Object)e));
        }
        finally {
            this.parserThread = null;
            this.queue.done();
            this.bindingNamesReady.countDown();
        }
    }

    public void startQueryResult(List<String> bindingNames) throws TupleQueryResultHandlerException {
        this.bindingNames = bindingNames;
        this.bindingNamesReady.countDown();
    }

    public void handleSolution(BindingSet bindingSet) throws TupleQueryResultHandlerException {
        if (this.closed) {
            throw new TupleQueryResultHandlerException("Result closed");
        }
        try {
            this.queue.put(bindingSet);
        }
        catch (InterruptedException e) {
            throw new TupleQueryResultHandlerException((Throwable)e);
        }
    }

    public void endQueryResult() throws TupleQueryResultHandlerException {
    }

    protected synchronized void handleClose() throws QueryEvaluationException {
        this.closed = true;
        if (this.parserThread != null) {
            this.parserThread.interrupt();
        }
        super.handleClose();
    }
}

