/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.http;

import java.io.IOException;
import org.openrdf.http.client.HTTPClient;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.query.TupleQueryResultHandlerException;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.http.HTTPQuery;
import org.openrdf.repository.http.HTTPQueryEvaluationException;
import org.openrdf.repository.http.HTTPRepositoryConnection;
import org.openrdf.repository.http.HTTPTupleQueryResult;

public class HTTPTupleQuery
extends HTTPQuery
implements TupleQuery {
    public HTTPTupleQuery(HTTPRepositoryConnection con, QueryLanguage ql, String queryString, String baseURI) {
        super(con, ql, queryString, baseURI);
    }

    public TupleQueryResult evaluate() throws QueryEvaluationException {
        HTTPClient client = this.httpCon.getRepository().getHTTPClient();
        HTTPTupleQueryResult result = new HTTPTupleQueryResult(client, this.queryLanguage, this.queryString, this.baseURI, this.dataset, this.includeInferred, this.getBindingsArray());
        this.execute(result);
        return result;
    }

    public void evaluate(TupleQueryResultHandler handler) throws QueryEvaluationException, TupleQueryResultHandlerException {
        HTTPClient client = this.httpCon.getRepository().getHTTPClient();
        try {
            client.sendTupleQuery(this.queryLanguage, this.queryString, this.baseURI, this.dataset, this.includeInferred, this.maxQueryTime, handler, this.getBindingsArray());
        }
        catch (IOException e) {
            throw new HTTPQueryEvaluationException(e.getMessage(), e);
        }
        catch (RepositoryException e) {
            throw new HTTPQueryEvaluationException(e.getMessage(), e);
        }
        catch (MalformedQueryException e) {
            throw new HTTPQueryEvaluationException(e.getMessage(), e);
        }
    }
}

