/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.http;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import org.openrdf.http.client.HTTPClient;
import org.openrdf.http.protocol.UnauthorizedException;
import org.openrdf.model.Statement;
import org.openrdf.query.Binding;
import org.openrdf.query.Dataset;
import org.openrdf.query.GraphQueryResult;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryInterruptedException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.impl.GraphQueryResultImpl;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.http.QueueCursor;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTTPGraphQueryResult
extends GraphQueryResultImpl
implements GraphQueryResult,
Runnable,
RDFHandler {
    private volatile boolean closed;
    private volatile Thread parserThread;
    private String baseURI;
    private CountDownLatch namespacesReady = new CountDownLatch(1);
    private Map<String, String> namespaces = new ConcurrentHashMap<String, String>();
    private QueueCursor<Statement> queue;
    private HTTPClient httpClient;
    private QueryLanguage queryLanguage;
    private String queryString;
    private Binding[] bindings;
    private boolean includeInferred;
    private Dataset dataset;

    public HTTPGraphQueryResult(HTTPClient httpClient, QueryLanguage queryLanguage, String queryString, String baseURI, Dataset dataset, boolean includeInferred, Binding ... bindings) {
        this(new QueueCursor<Statement>(10), httpClient, queryLanguage, queryString, baseURI, dataset, includeInferred, bindings);
    }

    public HTTPGraphQueryResult(QueueCursor<Statement> queue, HTTPClient httpClient, QueryLanguage queryLanguage, String queryString, String baseURI, Dataset dataset, boolean includeInferred, Binding ... bindings) {
        super(new HashMap(), queue);
        this.queue = queue;
        this.httpClient = httpClient;
        this.queryLanguage = queryLanguage;
        this.queryString = queryString;
        this.baseURI = baseURI;
        this.dataset = dataset;
        this.includeInferred = includeInferred;
        this.bindings = bindings;
    }

    public boolean hasNext() throws QueryEvaluationException {
        return this.queue.hasNext();
    }

    public Statement next() throws QueryEvaluationException {
        return (Statement)this.queue.next();
    }

    public void remove() throws QueryEvaluationException {
        this.queue.remove();
    }

    protected void handleClose() throws QueryEvaluationException {
        this.closed = true;
        if (this.parserThread != null) {
            this.parserThread.interrupt();
        }
        this.queue.close();
        super.handleClose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.parserThread = Thread.currentThread();
        try {
            this.httpClient.sendGraphQuery(this.queryLanguage, this.queryString, this.baseURI, this.dataset, this.includeInferred, 0, (RDFHandler)this, this.bindings);
        }
        catch (IOException e) {
            this.queue.toss(e);
        }
        catch (UnauthorizedException e) {
            this.queue.toss((Exception)((Object)e));
        }
        catch (QueryInterruptedException e) {
            this.queue.toss((Exception)((Object)e));
        }
        catch (RepositoryException e) {
            this.queue.toss((Exception)((Object)e));
        }
        catch (MalformedQueryException e) {
            this.queue.toss((Exception)((Object)e));
        }
        catch (RDFHandlerException e) {
            this.queue.toss((Exception)((Object)e));
        }
        finally {
            this.parserThread = null;
            this.queue.done();
        }
    }

    public void startRDF() throws RDFHandlerException {
    }

    public Map<String, String> getNamespaces() {
        try {
            this.namespacesReady.await();
            return this.namespaces;
        }
        catch (InterruptedException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    public void handleComment(String comment) throws RDFHandlerException {
    }

    public void handleNamespace(String prefix, String uri) throws RDFHandlerException {
        this.namespaces.put(prefix, uri);
    }

    public void handleStatement(Statement st) throws RDFHandlerException {
        this.namespacesReady.countDown();
        if (this.closed) {
            throw new RDFHandlerException("Result closed");
        }
        try {
            this.queue.put(st);
        }
        catch (InterruptedException e) {
            throw new RDFHandlerException((Throwable)e);
        }
    }

    public void endRDF() throws RDFHandlerException {
        this.namespacesReady.countDown();
    }
}

