/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.util;

import info.aduna.iteration.Iterations;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.BNode;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.util.ModelUtil;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean equals(Repository rep1, Repository rep2) throws RepositoryException {
        Set model2;
        Set model1;
        RepositoryConnection con1 = rep1.getConnection();
        try {
            model1 = Iterations.asSet(con1.getStatements(null, null, null, true, new Resource[0]));
        }
        finally {
            con1.close();
        }
        RepositoryConnection con2 = rep2.getConnection();
        try {
            model2 = Iterations.asSet(con2.getStatements(null, null, null, true, new Resource[0]));
        }
        finally {
            con2.close();
        }
        return ModelUtil.equals((Set)model1, (Set)model2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isSubset(Repository rep1, Repository rep2) throws RepositoryException {
        Set model2;
        Set model1;
        RepositoryConnection con1 = rep1.getConnection();
        try {
            model1 = Iterations.asSet(con1.getStatements(null, null, null, true, new Resource[0]));
        }
        finally {
            con1.close();
        }
        RepositoryConnection con2 = rep2.getConnection();
        try {
            model2 = Iterations.asSet(con2.getStatements(null, null, null, true, new Resource[0]));
        }
        finally {
            con2.close();
        }
        return ModelUtil.isSubset((Set)model1, (Set)model2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<? extends Statement> difference(Repository rep1, Repository rep2) throws RepositoryException {
        HashSet model1 = new HashSet();
        HashSet model2 = new HashSet();
        RepositoryConnection con1 = rep1.getConnection();
        try {
            Iterations.addAll(con1.getStatements(null, null, null, false, new Resource[0]), model1);
        }
        finally {
            con1.close();
        }
        RepositoryConnection con2 = rep2.getConnection();
        try {
            Iterations.addAll(con2.getStatements(null, null, null, false, new Resource[0]), model2);
        }
        finally {
            con2.close();
        }
        return RepositoryUtil.difference(model1, model2);
    }

    public static Collection<? extends Statement> difference(Collection<? extends Statement> model1, Collection<? extends Statement> model2) {
        LinkedList<? extends Statement> copy1 = new LinkedList<Statement>(model1);
        LinkedList<? extends Statement> copy2 = new LinkedList<Statement>(model2);
        ArrayList<Statement> result = new ArrayList<Statement>();
        Iterator iter1 = copy1.iterator();
        while (iter1.hasNext()) {
            Statement st = (Statement)iter1.next();
            if (st.getSubject() instanceof BNode || st.getObject() instanceof BNode) continue;
            boolean removed = copy2.remove(st);
            if (!removed) {
                result.add(st);
            }
            iter1.remove();
        }
        HashMap<BNode, BNode> bNodeMapping = new HashMap<BNode, BNode>();
        for (Statement statement : copy1) {
            boolean foundMatch = false;
            for (Statement statement2 : copy2) {
                if (!RepositoryUtil.statementsMatch(statement, statement2, bNodeMapping)) continue;
                foundMatch = true;
                break;
            }
            if (foundMatch) continue;
            result.add(statement);
        }
        return result;
    }

    private static boolean statementsMatch(Statement st1, Statement st2, Map<BNode, BNode> bNodeMapping) {
        BNode mappedBNode;
        BNode mappedBNode2;
        URI pred2;
        URI pred1 = st1.getPredicate();
        if (!pred1.equals(pred2 = st2.getPredicate())) {
            return false;
        }
        Resource subj1 = st1.getSubject();
        Resource subj2 = st2.getSubject();
        if (!(subj1 instanceof BNode) ? !subj1.equals(subj2) : ((mappedBNode2 = bNodeMapping.get(subj1)) != null ? !subj2.equals(mappedBNode2) : bNodeMapping.containsValue(subj2))) {
            return false;
        }
        Value obj1 = st1.getObject();
        Value obj2 = st2.getObject();
        return !(!(obj1 instanceof BNode) ? !obj1.equals(obj2) : ((mappedBNode = bNodeMapping.get(obj1)) != null ? !obj2.equals(mappedBNode) : bNodeMapping.containsValue(obj2)));
    }
}

