/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.resultio.sparqlxml;

import info.aduna.io.UncloseableInputStream;
import info.aduna.xml.SimpleSAXListener;
import info.aduna.xml.SimpleSAXParser;
import info.aduna.xml.XMLReaderFactory;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.openrdf.model.ValueFactory;
import org.openrdf.query.QueryResultHandlerException;
import org.openrdf.query.resultio.QueryResultParseException;
import org.openrdf.query.resultio.QueryResultParserBase;
import org.openrdf.query.resultio.sparqlxml.SPARQLBooleanSAXParser;
import org.openrdf.query.resultio.sparqlxml.SPARQLResultsSAXParser;
import org.xml.sax.SAXException;

public abstract class SPARQLXMLParserBase
extends QueryResultParserBase {
    public SPARQLXMLParserBase() {
    }

    public SPARQLXMLParserBase(ValueFactory valueFactory) {
        super(valueFactory);
    }

    public void parseQueryResult(InputStream in) throws IOException, QueryResultParseException, QueryResultHandlerException {
        this.parseQueryResultInternal(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean parseQueryResultInternal(InputStream in) throws IOException, QueryResultParseException, QueryResultHandlerException {
        BufferedInputStream buff = new BufferedInputStream(in);
        UncloseableInputStream uncloseable = new UncloseableInputStream((InputStream)buff);
        try {
            buff.mark(Integer.MAX_VALUE);
            boolean result = false;
            SAXException caughtException = null;
            try {
                SPARQLBooleanSAXParser valueParser = new SPARQLBooleanSAXParser();
                SimpleSAXParser booleanSAXParser = new SimpleSAXParser(XMLReaderFactory.createXMLReader());
                booleanSAXParser.setListener((SimpleSAXListener)valueParser);
                booleanSAXParser.parse((InputStream)uncloseable);
                result = valueParser.getValue();
                if (this.handler != null) {
                    try {
                        this.handler.handleBoolean(result);
                    }
                    catch (QueryResultHandlerException e) {
                        if (e.getCause() != null && e.getCause() instanceof IOException) {
                            throw (IOException)e.getCause();
                        }
                        throw new QueryResultParseException("Found an issue with the query result handler", (Throwable)e);
                    }
                }
                boolean bl = result;
                return bl;
            }
            catch (SAXException e) {
                caughtException = e;
                buff.reset();
                try {
                    SimpleSAXParser resultsSAXParser = new SimpleSAXParser(XMLReaderFactory.createXMLReader());
                    resultsSAXParser.setPreserveWhitespace(true);
                    resultsSAXParser.setListener((SimpleSAXListener)new SPARQLResultsSAXParser(this.valueFactory, this.handler));
                    resultsSAXParser.parse((InputStream)uncloseable);
                    caughtException = null;
                }
                catch (SAXException e2) {
                    caughtException = e2;
                }
                if (caughtException != null) {
                    Exception wrappedExc = caughtException.getException();
                    if (wrappedExc == null) {
                        throw new QueryResultParseException((Throwable)caughtException);
                    }
                    if (wrappedExc instanceof QueryResultParseException) {
                        throw (QueryResultParseException)wrappedExc;
                    }
                    if (wrappedExc instanceof QueryResultHandlerException) {
                        throw (QueryResultHandlerException)((Object)wrappedExc);
                    }
                    throw new QueryResultParseException((Throwable)wrappedExc);
                }
                boolean bl = result;
                uncloseable.doClose();
                return bl;
            }
        }
        finally {
            uncloseable.doClose();
        }
    }
}

