/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.resultio.sparqlxml;

import info.aduna.xml.SimpleSAXAdapter;
import info.aduna.xml.SimpleSAXListener;
import info.aduna.xml.SimpleSAXParser;
import info.aduna.xml.XMLReaderFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.query.BindingSet;
import org.openrdf.query.TupleQueryResultHandlerException;
import org.openrdf.query.impl.MapBindingSet;
import org.openrdf.query.resultio.QueryResultParseException;
import org.openrdf.query.resultio.TupleQueryResultFormat;
import org.openrdf.query.resultio.TupleQueryResultParserBase;
import org.xml.sax.SAXException;

public class SPARQLResultsXMLParser
extends TupleQueryResultParserBase {
    public SPARQLResultsXMLParser() {
    }

    public SPARQLResultsXMLParser(ValueFactory valueFactory) {
        super(valueFactory);
    }

    public TupleQueryResultFormat getTupleQueryResultFormat() {
        return TupleQueryResultFormat.SPARQL;
    }

    public void parse(InputStream in) throws IOException, QueryResultParseException, TupleQueryResultHandlerException {
        try {
            SimpleSAXParser simpleSAXParser = new SimpleSAXParser(XMLReaderFactory.createXMLReader());
            simpleSAXParser.setListener((SimpleSAXListener)new SPARQLResultsParser());
            simpleSAXParser.parse(in);
        }
        catch (SAXException e) {
            Exception wrappedExc = e.getException();
            if (wrappedExc instanceof QueryResultParseException) {
                throw (QueryResultParseException)wrappedExc;
            }
            if (wrappedExc instanceof TupleQueryResultHandlerException) {
                throw (TupleQueryResultHandlerException)((Object)wrappedExc);
            }
            throw new QueryResultParseException((Throwable)wrappedExc);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SPARQLResultsParser
    extends SimpleSAXAdapter {
        private List<String> bindingNames;
        private String currentBindingName;
        private Value currentValue;
        private MapBindingSet currentSolution;

        private SPARQLResultsParser() {
        }

        public void startDocument() throws SAXException {
            this.bindingNames = new ArrayList<String>();
            this.currentValue = null;
        }

        public void endDocument() throws SAXException {
            try {
                SPARQLResultsXMLParser.this.handler.endQueryResult();
            }
            catch (TupleQueryResultHandlerException e) {
                throw new SAXException((Exception)((Object)e));
            }
        }

        public void startTag(String tagName, Map<String, String> atts, String text) throws SAXException {
            if ("binding".equals(tagName)) {
                this.currentBindingName = atts.get("name");
                if (this.currentBindingName == null) {
                    throw new SAXException("name attribute missing for binding element");
                }
            } else {
                if ("uri".equals(tagName)) {
                    try {
                        this.currentValue = SPARQLResultsXMLParser.this.valueFactory.createURI(text);
                    }
                    catch (IllegalArgumentException e) {
                        throw new SAXException(e.getMessage());
                    }
                }
                if ("bnode".equals(tagName)) {
                    this.currentValue = SPARQLResultsXMLParser.this.valueFactory.createBNode(text);
                } else if ("literal".equals(tagName)) {
                    String xmlLang = atts.get("xml:lang");
                    String datatype = atts.get("datatype");
                    if (datatype != null) {
                        try {
                            this.currentValue = SPARQLResultsXMLParser.this.valueFactory.createLiteral(text, SPARQLResultsXMLParser.this.valueFactory.createURI(datatype));
                        }
                        catch (IllegalArgumentException e) {
                            throw new SAXException(e.getMessage());
                        }
                    } else {
                        this.currentValue = xmlLang != null ? SPARQLResultsXMLParser.this.valueFactory.createLiteral(text, xmlLang) : SPARQLResultsXMLParser.this.valueFactory.createLiteral(text);
                    }
                } else if ("result".equals(tagName)) {
                    this.currentSolution = new MapBindingSet(this.bindingNames.size());
                } else if ("variable".equals(tagName)) {
                    String varName = atts.get("name");
                    if (varName == null) {
                        throw new SAXException("name missing for variable element");
                    }
                    this.bindingNames.add(varName);
                } else if ("results".equals(tagName)) {
                    try {
                        SPARQLResultsXMLParser.this.handler.startQueryResult(this.bindingNames);
                    }
                    catch (TupleQueryResultHandlerException e) {
                        throw new SAXException((Exception)((Object)e));
                    }
                }
            }
        }

        public void endTag(String tagName) throws SAXException {
            if ("binding".equals(tagName)) {
                if (this.currentValue == null) {
                    throw new SAXException("Value missing for binding element");
                }
                this.currentSolution.addBinding(this.currentBindingName, this.currentValue);
                this.currentBindingName = null;
                this.currentValue = null;
            } else if ("result".equals(tagName)) {
                try {
                    SPARQLResultsXMLParser.this.handler.handleSolution((BindingSet)this.currentSolution);
                    this.currentSolution = null;
                }
                catch (TupleQueryResultHandlerException e) {
                    throw new SAXException((Exception)((Object)e));
                }
            }
        }
    }
}

