/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.resultio.sparqljson;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import org.openrdf.model.Literal;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryResultHandlerException;
import org.openrdf.query.impl.MapBindingSet;
import org.openrdf.query.resultio.QueryResultParseException;
import org.openrdf.query.resultio.QueryResultParserBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SPARQLJSONParserBase
extends QueryResultParserBase {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final JsonFactory JSON_FACTORY = new JsonFactory();
    public static final String HEAD = "head";
    public static final String LINK = "link";
    public static final String VARS = "vars";
    public static final String BOOLEAN = "boolean";
    public static final String RESULTS = "results";
    public static final String BINDINGS = "bindings";
    public static final String TYPE = "type";
    public static final String VALUE = "value";
    public static final String XMLLANG = "xml:lang";
    public static final String DATATYPE = "datatype";
    public static final String LITERAL = "literal";
    public static final String TYPED_LITERAL = "typed-literal";
    public static final String BNODE = "bnode";
    public static final String URI = "uri";
    private static final String DISTINCT = "distinct";
    private static final String ORDERED = "ordered";

    public SPARQLJSONParserBase() {
    }

    public SPARQLJSONParserBase(ValueFactory valueFactory) {
        super(valueFactory);
    }

    public void parseQueryResult(InputStream in) throws IOException, QueryResultParseException, QueryResultHandlerException {
        this.parseQueryResultInternal(in);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean parseQueryResultInternal(InputStream in) throws IOException, QueryResultParseException, QueryResultHandlerException {
        JsonParser jp = JSON_FACTORY.createJsonParser(in);
        boolean result = false;
        if (jp.nextToken() != JsonToken.START_OBJECT) {
            throw new QueryResultParseException("Expected SPARQL Results JSON document to start with an Object", jp.getCurrentLocation().getLineNr(), jp.getCurrentLocation().getColumnNr());
        }
        ArrayList<String> varsList = new ArrayList<String>();
        boolean varsFound = false;
        HashSet<MapBindingSet> bindings = new HashSet<MapBindingSet>();
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String baseStr = jp.getCurrentName();
            if (baseStr.equals(HEAD)) {
                if (jp.nextToken() != JsonToken.START_OBJECT) {
                    throw new QueryResultParseException("Did not find object under " + baseStr + " field", jp.getCurrentLocation().getLineNr(), jp.getCurrentLocation().getColumnNr());
                }
                while (jp.nextToken() != JsonToken.END_OBJECT) {
                    String headStr = jp.getCurrentName();
                    if (headStr.equals(VARS)) {
                        if (jp.nextToken() != JsonToken.START_ARRAY) {
                            throw new QueryResultParseException("Expected variable labels to be an array", jp.getCurrentLocation().getLineNr(), jp.getCurrentLocation().getColumnNr());
                        }
                        while (jp.nextToken() != JsonToken.END_ARRAY) {
                            varsList.add(jp.getText());
                        }
                        if (this.handler != null) {
                            this.handler.startQueryResult(varsList);
                        }
                        varsFound = true;
                        if (bindings.isEmpty() || this.handler == null) continue;
                        for (BindingSet bindingSet : bindings) {
                            this.handler.handleSolution(bindingSet);
                            this.handler.endQueryResult();
                        }
                        bindings.clear();
                        continue;
                    }
                    if (headStr.equals(LINK)) {
                        ArrayList<String> linksList = new ArrayList<String>();
                        if (jp.nextToken() != JsonToken.START_ARRAY) {
                            throw new QueryResultParseException("Expected links to be an array", jp.getCurrentLocation().getLineNr(), jp.getCurrentLocation().getColumnNr());
                        }
                        while (jp.nextToken() != JsonToken.END_ARRAY) {
                            linksList.add(jp.getText());
                        }
                        if (this.handler == null) continue;
                        this.handler.handleLinks(linksList);
                        continue;
                    }
                    throw new QueryResultParseException("Found unexpected object in head field: " + headStr, jp.getCurrentLocation().getLineNr(), jp.getCurrentLocation().getColumnNr());
                }
                continue;
            }
            if (baseStr.equals(RESULTS)) {
                if (jp.nextToken() != JsonToken.START_OBJECT) {
                    throw new QueryResultParseException("Found unexpected token in results object: " + jp.getCurrentName(), jp.getCurrentLocation().getLineNr(), jp.getCurrentLocation().getColumnNr());
                }
                while (jp.nextToken() != JsonToken.END_OBJECT) {
                    if (jp.getCurrentName().equals(BINDINGS)) {
                        if (jp.nextToken() != JsonToken.START_ARRAY) {
                            throw new QueryResultParseException("Found unexpected token in bindings object", jp.getCurrentLocation().getLineNr(), jp.getCurrentLocation().getColumnNr());
                        }
                        while (jp.nextToken() != JsonToken.END_ARRAY) {
                            MapBindingSet nextBindingSet = new MapBindingSet();
                            if (jp.getCurrentToken() != JsonToken.START_OBJECT) {
                                throw new QueryResultParseException("Did not find object in bindings array: " + jp.getCurrentName(), jp.getCurrentLocation().getLineNr(), jp.getCurrentLocation().getColumnNr());
                            }
                            while (jp.nextToken() != JsonToken.END_OBJECT) {
                                void var10_13;
                                if (jp.getCurrentToken() != JsonToken.FIELD_NAME) {
                                    throw new QueryResultParseException("Did not find binding name", jp.getCurrentLocation().getLineNr(), jp.getCurrentLocation().getColumnNr());
                                }
                                String bindingStr = jp.getCurrentName();
                                if (jp.nextToken() != JsonToken.START_OBJECT) {
                                    throw new QueryResultParseException("Did not find object for binding value", jp.getCurrentLocation().getLineNr(), jp.getCurrentLocation().getColumnNr());
                                }
                                Object var10_12 = null;
                                String type = null;
                                String datatype = null;
                                String value = null;
                                while (jp.nextToken() != JsonToken.END_OBJECT) {
                                    if (jp.getCurrentToken() != JsonToken.FIELD_NAME) {
                                        throw new QueryResultParseException("Did not find value attribute under " + bindingStr + " field", jp.getCurrentLocation().getLineNr(), jp.getCurrentLocation().getColumnNr());
                                    }
                                    String fieldName = jp.getCurrentName();
                                    jp.nextToken();
                                    if (TYPE.equals(fieldName)) {
                                        type = jp.getText();
                                        continue;
                                    }
                                    if (XMLLANG.equals(fieldName)) {
                                        String string = jp.getText();
                                        continue;
                                    }
                                    if (DATATYPE.equals(fieldName)) {
                                        datatype = jp.getText();
                                        continue;
                                    }
                                    if (VALUE.equals(fieldName)) {
                                        value = jp.getText();
                                        continue;
                                    }
                                    throw new QueryResultParseException("Unexpected field name: " + fieldName, jp.getCurrentLocation().getLineNr(), jp.getCurrentLocation().getColumnNr());
                                }
                                nextBindingSet.addBinding(bindingStr, this.parseValue(type, value, (String)var10_13, datatype));
                            }
                            if (!varsFound) {
                                bindings.add(nextBindingSet);
                                continue;
                            }
                            if (this.handler == null) continue;
                            this.handler.handleSolution((BindingSet)nextBindingSet);
                        }
                        if (this.handler == null) continue;
                        this.handler.endQueryResult();
                        continue;
                    }
                    if (jp.getCurrentName().equals(DISTINCT) || jp.getCurrentName().equals(ORDERED)) {
                        jp.nextToken();
                        continue;
                    }
                    throw new QueryResultParseException("Found unexpected field in results: " + jp.getCurrentName(), jp.getCurrentLocation().getLineNr(), jp.getCurrentLocation().getColumnNr());
                }
                continue;
            }
            if (baseStr.equals(BOOLEAN)) {
                jp.nextToken();
                result = Boolean.parseBoolean(jp.getText());
                if (this.handler == null) continue;
                this.handler.handleBoolean(result);
                continue;
            }
            throw new QueryResultParseException("Found unexpected object in top level " + baseStr + " field", jp.getCurrentLocation().getLineNr(), jp.getCurrentLocation().getColumnNr());
        }
        return result;
    }

    private Value parseValue(String type, String value, String language, String datatype) {
        this.logger.trace("type: {}", (Object)type);
        this.logger.trace("value: {}", (Object)value);
        this.logger.trace("language: {}", (Object)language);
        this.logger.trace("datatype: {}", (Object)datatype);
        Literal result = null;
        if (type.equals(LITERAL) || type.equals(TYPED_LITERAL)) {
            result = language != null ? this.valueFactory.createLiteral(value, language) : (datatype != null ? this.valueFactory.createLiteral(value, this.valueFactory.createURI(datatype)) : this.valueFactory.createLiteral(value));
        } else if (type.equals(BNODE)) {
            result = this.valueFactory.createBNode(value);
        } else if (type.equals(URI)) {
            result = this.valueFactory.createURI(value);
        }
        this.logger.debug("result value: {}", (Object)result);
        return result;
    }

    static {
        JSON_FACTORY.disable(JsonFactory.Feature.INTERN_FIELD_NAMES);
        JSON_FACTORY.disable(JsonFactory.Feature.CANONICALIZE_FIELD_NAMES);
        JSON_FACTORY.disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
    }
}

