/* 
 * Licensed to Aduna under one or more contributor license agreements.  
 * See the NOTICE.txt file distributed with this work for additional 
 * information regarding copyright ownership. 
 *
 * Aduna licenses this file to you under the terms of the Aduna BSD 
 * License (the "License"); you may not use this file except in compliance 
 * with the License. See the LICENSE.txt file distributed with this work 
 * for the full License.
 *
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or 
 * implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package org.openrdf.query.resultio;

import java.util.Collection;
import java.util.Collections;

import org.openrdf.rio.RioSetting;
import org.openrdf.rio.WriterConfig;

/**
 * Base class for {@link QueryResultWriter}s offering common functionality for
 * query result writers.
 * 
 * @author Peter Ansell
 * @since 2.7.0
 */
public abstract class QueryResultWriterBase implements QueryResultWriter {

	private WriterConfig writerConfig = new WriterConfig();

	/**
	 * Default constructor.
	 */
	public QueryResultWriterBase() {
	}

	@Override
	public void setWriterConfig(WriterConfig config) {
		this.writerConfig = config;
	}

	@Override
	public WriterConfig getWriterConfig() {
		return this.writerConfig;
	}

	@Override
	public Collection<RioSetting<?>> getSupportedSettings() {
		return Collections.emptyList();
	}

}
