/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.parser.serql;

import java.util.ArrayList;
import java.util.HashSet;
import org.openrdf.query.parser.serql.ASTVisitorBase;
import org.openrdf.query.parser.serql.ast.ASTProjectionElem;
import org.openrdf.query.parser.serql.ast.ASTSelect;
import org.openrdf.query.parser.serql.ast.ASTString;
import org.openrdf.query.parser.serql.ast.ASTVar;
import org.openrdf.query.parser.serql.ast.Node;
import org.openrdf.query.parser.serql.ast.VisitorException;

class ProjectionAliasProcessor
extends ASTVisitorBase {
    ProjectionAliasProcessor() {
    }

    public Object visit(ASTSelect node, Object data) throws VisitorException {
        HashSet<String> aliases = new HashSet<String>();
        ArrayList<Node> unaliasedNodes = new ArrayList<Node>();
        int i = 0;
        while (i < node.jjtGetNumChildren()) {
            Node projElem = (ASTProjectionElem)node.jjtGetChild(i);
            String alias = ((ASTProjectionElem)projElem).getAlias();
            if (alias == null && ((ASTProjectionElem)projElem).getValueExpr() instanceof ASTVar) {
                alias = ((ASTVar)((ASTProjectionElem)projElem).getValueExpr()).getName();
            }
            if (alias != null) {
                boolean isUnique = aliases.add(alias);
                if (!isUnique) {
                    throw new VisitorException("Duplicate projection element names: '" + alias + "'");
                }
            } else {
                unaliasedNodes.add(projElem);
            }
            ++i;
        }
        int aliasNo = 1;
        for (Node projElem : unaliasedNodes) {
            String alias;
            while (aliases.contains(alias = "_" + aliasNo++)) {
            }
            aliases.add(alias);
            ASTString aliasNode = new ASTString(64);
            aliasNode.setValue(alias);
            aliasNode.jjtSetParent(projElem);
            projElem.jjtAppendChild(aliasNode);
        }
        return data;
    }
}

