/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra;

import org.openrdf.query.algebra.QueryModelVisitor;
import org.openrdf.query.algebra.UnaryValueOperator;
import org.openrdf.query.algebra.ValueExpr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Like
extends UnaryValueOperator {
    private String pattern;
    private boolean caseSensitive;
    private String opPattern;

    public Like() {
    }

    public Like(ValueExpr expr, String pattern, boolean caseSensitive) {
        super(expr);
        this.setPattern(pattern, caseSensitive);
    }

    public void setPattern(String pattern, boolean caseSensitive) {
        assert (pattern != null) : "pattern must not be null";
        this.pattern = pattern;
        this.caseSensitive = caseSensitive;
        this.opPattern = caseSensitive ? pattern : pattern.toLowerCase();
    }

    public String getPattern() {
        return this.pattern;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public String getOpPattern() {
        return this.opPattern;
    }

    @Override
    public <X extends Exception> void visit(QueryModelVisitor<X> visitor) throws X {
        visitor.meet(this);
    }

    @Override
    public String getSignature() {
        StringBuilder sb = new StringBuilder(128);
        sb.append(super.getSignature());
        sb.append(" \"");
        sb.append(this.pattern);
        sb.append("\"");
        if (this.caseSensitive) {
            sb.append(" IGNORE CASE");
        }
        return sb.toString();
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof Like && super.equals(other)) {
            Like o = (Like)other;
            return this.caseSensitive == o.isCaseSensitive() && this.opPattern.equals(o.getOpPattern());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.opPattern.hashCode();
    }

    @Override
    public Like clone() {
        return (Like)super.clone();
    }
}

