/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.impl;

import java.util.HashSet;
import java.util.Set;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.algebra.And;
import org.openrdf.query.algebra.Difference;
import org.openrdf.query.algebra.EmptySet;
import org.openrdf.query.algebra.Filter;
import org.openrdf.query.algebra.Intersection;
import org.openrdf.query.algebra.Join;
import org.openrdf.query.algebra.LeftJoin;
import org.openrdf.query.algebra.Or;
import org.openrdf.query.algebra.QueryModelNode;
import org.openrdf.query.algebra.QueryModelVisitor;
import org.openrdf.query.algebra.SingletonSet;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.UnaryTupleOperator;
import org.openrdf.query.algebra.Union;
import org.openrdf.query.algebra.ValueConstant;
import org.openrdf.query.algebra.ValueExpr;
import org.openrdf.query.algebra.evaluation.QueryOptimizer;
import org.openrdf.query.algebra.evaluation.ValueExprEvaluationException;
import org.openrdf.query.algebra.evaluation.util.QueryEvaluationUtil;
import org.openrdf.query.algebra.helpers.QueryModelVisitorBase;
import org.openrdf.query.algebra.helpers.VarNameCollector;

public class QueryModelNormalizer
extends QueryModelVisitorBase<RuntimeException>
implements QueryOptimizer {
    @Override
    public void optimize(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings) {
        tupleExpr.visit((QueryModelVisitor)this);
    }

    public void meet(Join join) {
        super.meet(join);
        TupleExpr leftArg = join.getLeftArg();
        TupleExpr rightArg = join.getRightArg();
        if (leftArg instanceof EmptySet || rightArg instanceof EmptySet) {
            join.replaceWith((QueryModelNode)new EmptySet());
        } else if (leftArg instanceof SingletonSet) {
            join.replaceWith((QueryModelNode)rightArg);
        } else if (rightArg instanceof SingletonSet) {
            join.replaceWith((QueryModelNode)leftArg);
        } else if (leftArg instanceof Union) {
            Union union = (Union)leftArg;
            Join leftJoin = new Join(union.getLeftArg(), rightArg.clone());
            Join rightJoin = new Join(union.getRightArg(), rightArg.clone());
            Union newUnion = new Union((TupleExpr)leftJoin, (TupleExpr)rightJoin);
            join.replaceWith((QueryModelNode)newUnion);
            newUnion.visit((QueryModelVisitor)this);
        } else if (rightArg instanceof Union) {
            Union union = (Union)rightArg;
            Join leftJoin = new Join(leftArg.clone(), union.getLeftArg());
            Join rightJoin = new Join(leftArg.clone(), union.getRightArg());
            Union newUnion = new Union((TupleExpr)leftJoin, (TupleExpr)rightJoin);
            join.replaceWith((QueryModelNode)newUnion);
            newUnion.visit((QueryModelVisitor)this);
        } else if (leftArg instanceof LeftJoin && this.isWellDesigned((LeftJoin)leftArg)) {
            LeftJoin leftJoin = (LeftJoin)leftArg;
            join.replaceWith((QueryModelNode)leftJoin);
            join.setLeftArg(leftJoin.getLeftArg());
            leftJoin.setLeftArg((TupleExpr)join);
            leftJoin.visit((QueryModelVisitor)this);
        } else if (rightArg instanceof LeftJoin && this.isWellDesigned((LeftJoin)rightArg)) {
            LeftJoin leftJoin = (LeftJoin)rightArg;
            join.replaceWith((QueryModelNode)leftJoin);
            join.setRightArg(leftJoin.getLeftArg());
            leftJoin.setLeftArg((TupleExpr)join);
            leftJoin.visit((QueryModelVisitor)this);
        }
    }

    public void meet(LeftJoin leftJoin) {
        super.meet(leftJoin);
        TupleExpr leftArg = leftJoin.getLeftArg();
        TupleExpr rightArg = leftJoin.getRightArg();
        ValueExpr condition = leftJoin.getCondition();
        if (leftArg instanceof EmptySet) {
            leftJoin.replaceWith((QueryModelNode)leftArg);
        } else if (rightArg instanceof EmptySet) {
            leftJoin.replaceWith((QueryModelNode)leftArg);
        } else if (rightArg instanceof SingletonSet) {
            leftJoin.replaceWith((QueryModelNode)leftArg);
        } else if (condition instanceof ValueConstant) {
            boolean conditionValue;
            try {
                conditionValue = QueryEvaluationUtil.getEffectiveBooleanValue(((ValueConstant)condition).getValue());
            }
            catch (ValueExprEvaluationException e) {
                conditionValue = false;
            }
            if (!conditionValue) {
                leftJoin.replaceWith((QueryModelNode)leftArg);
            } else {
                leftJoin.setCondition(null);
            }
        }
    }

    public void meet(Union union) {
        super.meet(union);
        TupleExpr leftArg = union.getLeftArg();
        TupleExpr rightArg = union.getRightArg();
        if (leftArg instanceof EmptySet) {
            union.replaceWith((QueryModelNode)rightArg);
        } else if (rightArg instanceof EmptySet) {
            union.replaceWith((QueryModelNode)leftArg);
        } else if (leftArg instanceof SingletonSet && rightArg instanceof SingletonSet) {
            union.replaceWith((QueryModelNode)leftArg);
        }
    }

    public void meet(Difference difference) {
        super.meet(difference);
        TupleExpr leftArg = difference.getLeftArg();
        TupleExpr rightArg = difference.getRightArg();
        if (leftArg instanceof EmptySet) {
            difference.replaceWith((QueryModelNode)leftArg);
        } else if (rightArg instanceof EmptySet) {
            difference.replaceWith((QueryModelNode)leftArg);
        } else if (leftArg instanceof SingletonSet && rightArg instanceof SingletonSet) {
            difference.replaceWith((QueryModelNode)new EmptySet());
        }
    }

    public void meet(Intersection intersection) {
        super.meet(intersection);
        TupleExpr leftArg = intersection.getLeftArg();
        TupleExpr rightArg = intersection.getRightArg();
        if (leftArg instanceof EmptySet || rightArg instanceof EmptySet) {
            intersection.replaceWith((QueryModelNode)new EmptySet());
        }
    }

    protected void meetUnaryTupleOperator(UnaryTupleOperator node) {
        super.meetUnaryTupleOperator(node);
        if (node.getArg() instanceof EmptySet) {
            node.replaceWith((QueryModelNode)node.getArg());
        }
    }

    public void meet(Filter node) {
        super.meet(node);
        TupleExpr arg = node.getArg();
        ValueExpr condition = node.getCondition();
        if (!(arg instanceof EmptySet) && condition instanceof ValueConstant) {
            boolean conditionValue;
            try {
                conditionValue = QueryEvaluationUtil.getEffectiveBooleanValue(((ValueConstant)condition).getValue());
            }
            catch (ValueExprEvaluationException e) {
                conditionValue = false;
            }
            if (!conditionValue) {
                node.replaceWith((QueryModelNode)new EmptySet());
            } else {
                node.replaceWith((QueryModelNode)arg);
            }
        }
    }

    public void meet(Or or) {
        super.meet(or);
        if (or.getLeftArg().equals(or.getRightArg())) {
            or.replaceWith((QueryModelNode)or.getLeftArg());
        }
    }

    public void meet(And and) {
        super.meet(and);
        if (and.getLeftArg().equals(and.getRightArg())) {
            and.replaceWith((QueryModelNode)and.getLeftArg());
        }
    }

    private boolean isWellDesigned(LeftJoin leftJoin) {
        QueryModelNode parent;
        VarNameCollector optionalVarCollector = new VarNameCollector();
        leftJoin.getRightArg().visit((QueryModelVisitor)optionalVarCollector);
        if (leftJoin.hasCondition()) {
            leftJoin.getCondition().visit((QueryModelVisitor)optionalVarCollector);
        }
        Set problemVars = optionalVarCollector.getVarNames();
        problemVars.removeAll(leftJoin.getLeftArg().getBindingNames());
        if (problemVars.isEmpty()) {
            return true;
        }
        BindingCollector bindingCollector = new BindingCollector();
        LeftJoin node = leftJoin;
        while ((parent = node.getParentNode()) != null) {
            bindingCollector.setNodeToIgnore((QueryModelNode)node);
            parent.visitChildren((QueryModelVisitor)bindingCollector);
            node = parent;
        }
        problemVars.retainAll(bindingCollector.getBindingNames());
        return problemVars.isEmpty();
    }

    private static class BindingCollector
    extends QueryModelVisitorBase<RuntimeException> {
        private QueryModelNode nodeToIgnore;
        private final Set<String> bindingNames = new HashSet<String>();

        private BindingCollector() {
        }

        public void setNodeToIgnore(QueryModelNode node) {
            this.nodeToIgnore = node;
        }

        public Set<String> getBindingNames() {
            return this.bindingNames;
        }

        protected void meetNode(QueryModelNode node) {
            if (node instanceof TupleExpr && node != this.nodeToIgnore) {
                TupleExpr tupleExpr = (TupleExpr)node;
                this.bindingNames.addAll(tupleExpr.getBindingNames());
            }
        }
    }
}

