/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.util;

import javax.xml.datatype.XMLGregorianCalendar;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.datatypes.XMLDatatypeUtil;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.query.algebra.Compare;
import org.openrdf.query.algebra.evaluation.ValueExprEvaluationException;

public class QueryEvaluationUtil {
    public static boolean getEffectiveBooleanValue(Value value) throws ValueExprEvaluationException {
        if (value instanceof Literal) {
            Literal literal = (Literal)value;
            String label = literal.getLabel();
            URI datatype = literal.getDatatype();
            if (datatype == null || datatype.equals(XMLSchema.STRING)) {
                return label.length() > 0;
            }
            if (datatype.equals(XMLSchema.BOOLEAN)) {
                return "true".equals(label) || "1".equals(label);
            }
            if (datatype.equals(XMLSchema.DECIMAL)) {
                try {
                    String normDec = XMLDatatypeUtil.normalizeDecimal((String)label);
                    return !normDec.equals("0.0");
                }
                catch (IllegalArgumentException e) {
                    return false;
                }
            }
            if (XMLDatatypeUtil.isIntegerDatatype((URI)datatype)) {
                try {
                    String normInt = XMLDatatypeUtil.normalize((String)label, (URI)datatype);
                    return !normInt.equals("0");
                }
                catch (IllegalArgumentException e) {
                    return false;
                }
            }
            if (XMLDatatypeUtil.isFloatingPointDatatype((URI)datatype)) {
                try {
                    String normFP = XMLDatatypeUtil.normalize((String)label, (URI)datatype);
                    return !normFP.equals("0.0E0") && !normFP.equals("NaN");
                }
                catch (IllegalArgumentException e) {
                    return false;
                }
            }
        }
        throw new ValueExprEvaluationException();
    }

    public static boolean compare(Value leftVal, Value rightVal, Compare.CompareOp operator) throws ValueExprEvaluationException {
        if (leftVal instanceof Literal && rightVal instanceof Literal) {
            return QueryEvaluationUtil.compareLiterals((Literal)leftVal, (Literal)rightVal, operator);
        }
        switch (operator) {
            case EQ: {
                return QueryEvaluationUtil.valuesEqual(leftVal, rightVal);
            }
            case NE: {
                return !QueryEvaluationUtil.valuesEqual(leftVal, rightVal);
            }
        }
        throw new ValueExprEvaluationException("Only literals with compatible, ordered datatypes can be compared using <, <=, > and >= operators");
    }

    private static boolean valuesEqual(Value leftVal, Value rightVal) {
        return leftVal != null && rightVal != null && leftVal.equals(rightVal);
    }

    public static boolean compareLiterals(Literal leftLit, Literal rightLit, Compare.CompareOp operator) throws ValueExprEvaluationException {
        URI leftDatatype = leftLit.getDatatype();
        URI rightDatatype = rightLit.getDatatype();
        URI commonDatatype = null;
        if (QueryEvaluationUtil.isSimpleLiteral(leftLit) && XMLSchema.STRING.equals(rightDatatype)) {
            commonDatatype = XMLSchema.STRING;
        } else if (QueryEvaluationUtil.isSimpleLiteral(rightLit) && XMLSchema.STRING.equals(leftDatatype)) {
            commonDatatype = XMLSchema.STRING;
        }
        Integer compareResult = null;
        if (QueryEvaluationUtil.isSimpleLiteral(leftLit) && QueryEvaluationUtil.isSimpleLiteral(rightLit)) {
            compareResult = leftLit.getLabel().compareTo(rightLit.getLabel());
        } else if (leftDatatype != null && rightDatatype != null || commonDatatype != null) {
            if (commonDatatype == null) {
                if (leftDatatype.equals(rightDatatype)) {
                    commonDatatype = leftDatatype;
                } else if (XMLDatatypeUtil.isNumericDatatype((URI)leftDatatype) && XMLDatatypeUtil.isNumericDatatype((URI)rightDatatype)) {
                    commonDatatype = leftDatatype.equals(XMLSchema.DOUBLE) || rightDatatype.equals(XMLSchema.DOUBLE) ? XMLSchema.DOUBLE : (leftDatatype.equals(XMLSchema.FLOAT) || rightDatatype.equals(XMLSchema.FLOAT) ? XMLSchema.FLOAT : (leftDatatype.equals(XMLSchema.DECIMAL) || rightDatatype.equals(XMLSchema.DECIMAL) ? XMLSchema.DECIMAL : XMLSchema.INTEGER));
                }
            }
            if (commonDatatype != null) {
                try {
                    if (commonDatatype.equals(XMLSchema.DOUBLE)) {
                        compareResult = Double.compare(leftLit.doubleValue(), rightLit.doubleValue());
                    } else if (commonDatatype.equals(XMLSchema.FLOAT)) {
                        compareResult = Float.compare(leftLit.floatValue(), rightLit.floatValue());
                    } else if (commonDatatype.equals(XMLSchema.DECIMAL)) {
                        compareResult = leftLit.decimalValue().compareTo(rightLit.decimalValue());
                    } else if (XMLDatatypeUtil.isIntegerDatatype((URI)commonDatatype)) {
                        compareResult = leftLit.integerValue().compareTo(rightLit.integerValue());
                    } else if (commonDatatype.equals(XMLSchema.BOOLEAN)) {
                        Boolean leftBool = leftLit.booleanValue();
                        Boolean rightBool = rightLit.booleanValue();
                        compareResult = leftBool.compareTo(rightBool);
                    } else if (XMLDatatypeUtil.isCalendarDatatype((URI)commonDatatype)) {
                        XMLGregorianCalendar right;
                        XMLGregorianCalendar left = leftLit.calendarValue();
                        compareResult = left.compare(right = rightLit.calendarValue());
                        if (compareResult == 2) {
                            throw new ValueExprEvaluationException("Indeterminate result for date/time comparison");
                        }
                    } else if (commonDatatype.equals(XMLSchema.STRING)) {
                        compareResult = leftLit.getLabel().compareTo(rightLit.getLabel());
                    }
                }
                catch (IllegalArgumentException e) {
                    if (leftLit.equals(rightLit)) {
                        switch (operator) {
                            case EQ: {
                                return true;
                            }
                            case NE: {
                                return false;
                            }
                        }
                    }
                    throw new ValueExprEvaluationException(e);
                }
            }
        }
        if (compareResult != null) {
            switch (operator) {
                case LT: {
                    return compareResult < 0;
                }
                case LE: {
                    return compareResult <= 0;
                }
                case EQ: {
                    return compareResult == 0;
                }
                case NE: {
                    return compareResult != 0;
                }
                case GE: {
                    return compareResult >= 0;
                }
                case GT: {
                    return compareResult > 0;
                }
            }
            throw new IllegalArgumentException("Unknown operator: " + operator);
        }
        boolean literalsEqual = leftLit.equals(rightLit);
        if (!literalsEqual) {
            if (leftDatatype != null && rightDatatype != null && QueryEvaluationUtil.isSupportedDatatype(leftDatatype) && QueryEvaluationUtil.isSupportedDatatype(rightDatatype)) {
                if (!XMLDatatypeUtil.isValidValue((String)leftLit.getLabel(), (URI)leftDatatype)) {
                    throw new ValueExprEvaluationException("not a valid datatype value: " + leftLit);
                }
                if (!XMLDatatypeUtil.isValidValue((String)rightLit.getLabel(), (URI)rightDatatype)) {
                    throw new ValueExprEvaluationException("not a valid datatype value: " + rightLit);
                }
            } else if (leftDatatype != null && rightLit.getLanguage() == null || rightDatatype != null && leftLit.getLanguage() == null) {
                throw new ValueExprEvaluationException("Unable to compare literals with unsupported types");
            }
        }
        switch (operator) {
            case EQ: {
                return literalsEqual;
            }
            case NE: {
                return !literalsEqual;
            }
            case LT: 
            case LE: 
            case GE: 
            case GT: {
                throw new ValueExprEvaluationException("Only literals with compatible, ordered datatypes can be compared using <, <=, > and >= operators");
            }
        }
        throw new IllegalArgumentException("Unknown operator: " + operator);
    }

    public static boolean isPlainLiteral(Value v) {
        if (v instanceof Literal) {
            Literal l = (Literal)v;
            return l.getDatatype() == null;
        }
        return false;
    }

    public static boolean isSimpleLiteral(Value v) {
        if (v instanceof Literal) {
            return QueryEvaluationUtil.isSimpleLiteral((Literal)v);
        }
        return false;
    }

    public static boolean isSimpleLiteral(Literal l) {
        return l.getLanguage() == null && l.getDatatype() == null;
    }

    public static boolean isStringLiteral(Value v) {
        if (v instanceof Literal) {
            return QueryEvaluationUtil.isStringLiteral((Literal)v);
        }
        return false;
    }

    public static boolean compatibleArguments(Literal arg1, Literal arg2) {
        boolean compatible = (QueryEvaluationUtil.isSimpleLiteral(arg1) || XMLSchema.STRING.equals(arg1.getDatatype())) && (QueryEvaluationUtil.isSimpleLiteral(arg2) || XMLSchema.STRING.equals(arg2.getDatatype())) || QueryEvaluationUtil.isPlainLiteral((Value)arg1) && QueryEvaluationUtil.isPlainLiteral((Value)arg2) && arg1.getLanguage() != null && arg1.getLanguage().equals(arg2.getLanguage()) || QueryEvaluationUtil.isPlainLiteral((Value)arg1) && arg1.getLanguage() != null && (QueryEvaluationUtil.isSimpleLiteral(arg2) || XMLSchema.STRING.equals(arg2.getDatatype()));
        return compatible;
    }

    public static boolean isStringLiteral(Literal l) {
        URI datatype = l.getDatatype();
        return datatype == null || datatype.equals(XMLSchema.STRING);
    }

    private static boolean isSupportedDatatype(URI datatype) {
        return XMLSchema.STRING.equals(datatype) || XMLDatatypeUtil.isNumericDatatype((URI)datatype) || XMLDatatypeUtil.isCalendarDatatype((URI)datatype);
    }
}

