/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.function.string;

import org.openrdf.model.Literal;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.vocabulary.FN;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.query.algebra.evaluation.ValueExprEvaluationException;
import org.openrdf.query.algebra.evaluation.function.Function;
import org.openrdf.query.algebra.evaluation.util.QueryEvaluationUtil;

public class StrLen
implements Function {
    public String getURI() {
        return FN.STRING_LENGTH.toString();
    }

    public Literal evaluate(ValueFactory valueFactory, Value ... args) throws ValueExprEvaluationException {
        if (args.length != 1) {
            throw new ValueExprEvaluationException("STRLEN requires 1 argument, got " + args.length);
        }
        Value argValue = args[0];
        if (argValue instanceof Literal) {
            Literal literal = (Literal)argValue;
            if (QueryEvaluationUtil.isStringLiteral(literal)) {
                Integer length = literal.getLabel().length();
                return valueFactory.createLiteral(length.toString(), XMLSchema.INTEGER);
            }
            throw new ValueExprEvaluationException("unexpected input value for strlen function: " + argValue);
        }
        throw new ValueExprEvaluationException("unexpected input value for strlen function: " + argValue);
    }
}

