/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.function;

import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.datatypes.XMLDatatypeUtil;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.query.algebra.evaluation.ValueExprEvaluationException;
import org.openrdf.query.algebra.evaluation.function.Function;
import org.openrdf.query.algebra.evaluation.util.QueryEvaluationUtil;

public class StringCast
implements Function {
    public String getURI() {
        return XMLSchema.STRING.toString();
    }

    public Literal evaluate(ValueFactory valueFactory, Value ... args) throws ValueExprEvaluationException {
        if (args.length != 1) {
            throw new ValueExprEvaluationException("xsd:string cast requires exactly 1 argument, got " + args.length);
        }
        Value value = args[0];
        if (value instanceof URI) {
            return valueFactory.createLiteral(value.toString(), XMLSchema.STRING);
        }
        if (value instanceof Literal) {
            Literal literal = (Literal)value;
            URI datatype = literal.getDatatype();
            if (QueryEvaluationUtil.isSimpleLiteral(literal)) {
                return valueFactory.createLiteral(literal.getLabel(), XMLSchema.STRING);
            }
            if (datatype != null) {
                if (datatype.equals((Object)XMLSchema.STRING)) {
                    return literal;
                }
                if (XMLDatatypeUtil.isNumericDatatype((URI)datatype) || datatype.equals((Object)XMLSchema.BOOLEAN) || datatype.equals((Object)XMLSchema.DATETIME)) {
                    if (XMLDatatypeUtil.isValidValue((String)literal.getLabel(), (URI)datatype)) {
                        String normalizedValue = XMLDatatypeUtil.normalize((String)literal.getLabel(), (URI)datatype);
                        return valueFactory.createLiteral(normalizedValue, XMLSchema.STRING);
                    }
                    return valueFactory.createLiteral(literal.getLabel(), XMLSchema.STRING);
                }
                return valueFactory.createLiteral(literal.getLabel(), XMLSchema.STRING);
            }
        }
        throw new ValueExprEvaluationException("Invalid argument for xsd:string cast: " + value);
    }
}

