/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query;

import info.aduna.iteration.Iterations;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.datatype.XMLGregorianCalendar;
import org.openrdf.model.BNode;
import org.openrdf.model.Graph;
import org.openrdf.model.Literal;
import org.openrdf.model.Model;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.datatypes.XMLDatatypeUtil;
import org.openrdf.model.impl.GraphImpl;
import org.openrdf.model.impl.LinkedHashModel;
import org.openrdf.model.util.ModelUtil;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.query.Binding;
import org.openrdf.query.BindingSet;
import org.openrdf.query.GraphQueryResult;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.query.TupleQueryResultHandlerException;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;

public class QueryResults
extends Iterations {
    public static Graph asGraph(GraphQueryResult gqr) throws QueryEvaluationException {
        GraphImpl graph = new GraphImpl();
        QueryResults.addAll(gqr, graph);
        return graph;
    }

    public static Model asModel(GraphQueryResult gqr) throws QueryEvaluationException {
        LinkedHashModel model = new LinkedHashModel();
        QueryResults.addAll(gqr, model);
        return model;
    }

    public static Statement singleResult(GraphQueryResult result) throws QueryEvaluationException {
        Statement singleResult = null;
        if (result.hasNext()) {
            singleResult = (Statement)result.next();
        }
        result.close();
        return singleResult;
    }

    public BindingSet singleResult(TupleQueryResult result) throws QueryEvaluationException {
        BindingSet singleResult = null;
        if (result.hasNext()) {
            singleResult = (BindingSet)result.next();
        }
        result.close();
        return singleResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void report(TupleQueryResult tqr, TupleQueryResultHandler handler) throws TupleQueryResultHandlerException, QueryEvaluationException {
        handler.startQueryResult(tqr.getBindingNames());
        try {
            while (tqr.hasNext()) {
                BindingSet bindingSet = (BindingSet)tqr.next();
                handler.handleSolution(bindingSet);
            }
        }
        finally {
            tqr.close();
        }
        handler.endQueryResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void report(GraphQueryResult gqr, RDFHandler rdfHandler) throws RDFHandlerException, QueryEvaluationException {
        try {
            rdfHandler.startRDF();
            for (Map.Entry<String, String> entry : gqr.getNamespaces().entrySet()) {
                String prefix = entry.getKey();
                String namespace = entry.getValue();
                rdfHandler.handleNamespace(prefix, namespace);
            }
            while (gqr.hasNext()) {
                Statement st = (Statement)gqr.next();
                rdfHandler.handleStatement(st);
            }
            rdfHandler.endRDF();
        }
        finally {
            gqr.close();
        }
    }

    public static boolean equals(TupleQueryResult tqr1, TupleQueryResult tqr2) throws QueryEvaluationException {
        List<BindingSet> list1 = Iterations.asList(tqr1);
        List<BindingSet> list2 = Iterations.asList(tqr2);
        if (list1.size() != list2.size()) {
            return false;
        }
        return QueryResults.matchBindingSets(list1, list2);
    }

    public static boolean isSubset(TupleQueryResult tqr1, TupleQueryResult tqr2) throws QueryEvaluationException {
        List<BindingSet> list1 = Iterations.asList(tqr1);
        List<BindingSet> list2 = Iterations.asList(tqr2);
        if (list1.size() > list2.size()) {
            return false;
        }
        return QueryResults.matchBindingSets(list1, list2);
    }

    public static boolean equals(GraphQueryResult result1, GraphQueryResult result2) throws QueryEvaluationException {
        Set<Statement> graph1 = Iterations.asSet(result1);
        Set<Statement> graph2 = Iterations.asSet(result1);
        return ModelUtil.equals(graph1, graph2);
    }

    private static boolean matchBindingSets(List<? extends BindingSet> queryResult1, Iterable<? extends BindingSet> queryResult2) {
        return QueryResults.matchBindingSets(queryResult1, queryResult2, new HashMap<BNode, BNode>(), 0);
    }

    private static boolean matchBindingSets(List<? extends BindingSet> queryResult1, Iterable<? extends BindingSet> queryResult2, Map<BNode, BNode> bNodeMapping, int idx) {
        boolean result = false;
        if (idx < queryResult1.size()) {
            BindingSet bs1 = queryResult1.get(idx);
            List<BindingSet> matchingBindingSets = QueryResults.findMatchingBindingSets(bs1, queryResult2, bNodeMapping);
            for (BindingSet bs2 : matchingBindingSets) {
                HashMap<BNode, BNode> newBNodeMapping = new HashMap<BNode, BNode>(bNodeMapping);
                for (Binding binding : bs1) {
                    if (!(binding.getValue() instanceof BNode)) continue;
                    newBNodeMapping.put((BNode)binding.getValue(), (BNode)bs2.getValue(binding.getName()));
                }
                result = QueryResults.matchBindingSets(queryResult1, queryResult2, newBNodeMapping, idx + 1);
                if (!result) continue;
                break;
            }
        } else {
            result = true;
        }
        return result;
    }

    private static List<BindingSet> findMatchingBindingSets(BindingSet st, Iterable<? extends BindingSet> model, Map<BNode, BNode> bNodeMapping) {
        ArrayList<BindingSet> result = new ArrayList<BindingSet>();
        for (BindingSet bindingSet : model) {
            if (!QueryResults.bindingSetsMatch(st, bindingSet, bNodeMapping)) continue;
            result.add(bindingSet);
        }
        return result;
    }

    private static boolean bindingSetsMatch(BindingSet bs1, BindingSet bs2, Map<BNode, BNode> bNodeMapping) {
        if (bs1.size() != bs2.size()) {
            return false;
        }
        for (Binding binding1 : bs1) {
            Value value1 = binding1.getValue();
            Value value2 = bs2.getValue(binding1.getName());
            if (value1 instanceof BNode && value2 instanceof BNode) {
                BNode mappedBNode = bNodeMapping.get(value1);
                if (!(mappedBNode != null ? !value2.equals(mappedBNode) : bNodeMapping.containsValue(value2))) continue;
                return false;
            }
            if (value1 instanceof Literal && value2 instanceof Literal) {
                Literal leftLit = (Literal)value1;
                Literal rightLit = (Literal)value2;
                URI dt1 = leftLit.getDatatype();
                URI dt2 = rightLit.getDatatype();
                if (dt1 != null && dt2 != null && dt1.equals((Object)dt2) && XMLDatatypeUtil.isValidValue((String)leftLit.getLabel(), (URI)dt1) && XMLDatatypeUtil.isValidValue((String)rightLit.getLabel(), (URI)dt2)) {
                    Integer compareResult = null;
                    if (dt1.equals((Object)XMLSchema.DOUBLE)) {
                        compareResult = Double.compare(leftLit.doubleValue(), rightLit.doubleValue());
                    } else if (dt1.equals((Object)XMLSchema.FLOAT)) {
                        compareResult = Float.compare(leftLit.floatValue(), rightLit.floatValue());
                    } else if (dt1.equals((Object)XMLSchema.DECIMAL)) {
                        compareResult = leftLit.decimalValue().compareTo(rightLit.decimalValue());
                    } else if (XMLDatatypeUtil.isIntegerDatatype((URI)dt1)) {
                        compareResult = leftLit.integerValue().compareTo(rightLit.integerValue());
                    } else if (dt1.equals((Object)XMLSchema.BOOLEAN)) {
                        Boolean leftBool = leftLit.booleanValue();
                        Boolean rightBool = rightLit.booleanValue();
                        compareResult = leftBool.compareTo(rightBool);
                    } else if (XMLDatatypeUtil.isCalendarDatatype((URI)dt1)) {
                        XMLGregorianCalendar left = leftLit.calendarValue();
                        XMLGregorianCalendar right = rightLit.calendarValue();
                        compareResult = left.compare(right);
                    }
                    if (!(compareResult != null ? compareResult != 0 : !value1.equals(value2))) continue;
                    return false;
                }
                if (value1.equals(value2)) continue;
                return false;
            }
            if (value1.equals(value2)) continue;
            return false;
        }
        return true;
    }

    public static boolean bindingSetsCompatible(BindingSet bs1, BindingSet bs2) {
        HashSet<String> sharedBindings = new HashSet<String>(bs1.getBindingNames());
        sharedBindings.retainAll(bs2.getBindingNames());
        for (String bindingName : sharedBindings) {
            Value value2;
            Value value1 = bs1.getValue(bindingName);
            if (value1.equals(value2 = bs2.getValue(bindingName))) continue;
            return false;
        }
        return true;
    }
}

