/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.impl;

import java.util.Set;
import org.openrdf.model.URI;
import org.openrdf.query.Dataset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FallbackDataset
implements Dataset {
    private Dataset primary;
    private Dataset fallback;

    public static Dataset fallback(Dataset primary, Dataset fallback) {
        if (primary == null) {
            return fallback;
        }
        if (fallback == null) {
            return primary;
        }
        return new FallbackDataset(primary, fallback);
    }

    private FallbackDataset(Dataset primary, Dataset secondary) {
        assert (primary != null);
        assert (secondary != null);
        this.primary = primary;
        this.fallback = secondary;
    }

    @Override
    public Set<URI> getDefaultGraphs() {
        Set<URI> set = this.primary.getDefaultGraphs();
        if (set == null || set.isEmpty()) {
            return this.fallback.getDefaultGraphs();
        }
        return set;
    }

    @Override
    public Set<URI> getNamedGraphs() {
        Set<URI> set = this.primary.getNamedGraphs();
        if (set == null || set.isEmpty()) {
            return this.fallback.getNamedGraphs();
        }
        return set;
    }

    @Override
    public URI getDefaultInsertGraph() {
        URI graph = this.primary.getDefaultInsertGraph();
        if (graph == null) {
            return this.fallback.getDefaultInsertGraph();
        }
        return graph;
    }

    @Override
    public Set<URI> getDefaultRemoveGraphs() {
        Set<URI> set = this.primary.getDefaultRemoveGraphs();
        if (set == null || set.isEmpty()) {
            return this.fallback.getDefaultRemoveGraphs();
        }
        return set;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (URI uri : this.getDefaultRemoveGraphs()) {
            sb.append("DELETE FROM ");
            this.appendURI(sb, uri);
        }
        sb.append("INSERT INTO ");
        this.appendURI(sb, this.getDefaultInsertGraph());
        for (URI uri : this.getDefaultGraphs()) {
            sb.append("USING ");
            this.appendURI(sb, uri);
        }
        for (URI uri : this.getNamedGraphs()) {
            sb.append("USING NAMED ");
            this.appendURI(sb, uri);
        }
        return sb.toString();
    }

    private void appendURI(StringBuilder sb, URI uri) {
        String str = uri.toString();
        if (str.length() > 50) {
            sb.append("<").append(str, 0, 19).append("..");
            sb.append(str, str.length() - 29, str.length()).append(">\n");
        } else {
            sb.append("<").append(uri).append(">\n");
        }
    }
}

