/* 
 * Licensed to Aduna under one or more contributor license agreements.  
 * See the NOTICE.txt file distributed with this work for additional 
 * information regarding copyright ownership. 
 *
 * Aduna licenses this file to you under the terms of the Aduna BSD 
 * License (the "License"); you may not use this file except in compliance 
 * with the License. See the LICENSE.txt file distributed with this work 
 * for the full License.
 *
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or 
 * implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package org.openrdf.model;

import java.io.Serializable;

/**
 * A namespace, consisting of a namespace name and a prefix that has been
 * assigned to it.
 */
public interface Namespace extends Serializable, Comparable<Namespace> {

	/**
	 * Gets the name of the current namespace (i.e. it's URI).
	 * 
	 * @return name of namespace
	 */
	public String getName();

	/**
	 * Gets the prefix of the current namespace. The default namespace is
	 * represented by an empty prefix string.
	 * 
	 * @return prefix of namespace, or an empty string in case of the default
	 *         namespace.
	 */
	public String getPrefix();
}
